/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.epp.internal.logging.aeri.ui.UploadJob;
import org.eclipse.epp.internal.logging.aeri.ui.log.ReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.v2.AeriServer;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerConfiguration;

public class UploadHandler
extends JobChangeAdapter {
    private final Settings settings;
    private final EventBus bus;
    private final Set<ErrorReport> events = Sets.newConcurrentHashSet();
    @VisibleForTesting
    protected volatile Job scheduledJob;
    private ReportHistory history;
    private AeriServer server;
    private ServerConfiguration configuration;

    public UploadHandler(Settings settings, ServerConfiguration configuration, AeriServer server, ReportHistory history, EventBus bus) {
        this.settings = settings;
        this.configuration = configuration;
        this.server = server;
        this.history = history;
        this.bus = bus;
    }

    public void scheduleForSending(final List<ErrorReport> reports) {
        new Job("Schedule Reports for sending"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Scheduling...", reports.size());
                for (ErrorReport report : reports) {
                    UploadHandler.this.history.remember(report);
                    UploadHandler.this.addForSending(report);
                    monitor.worked(1);
                    if (monitor.isCanceled()) break;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void addForSending(ErrorReport report) {
        boolean add = this.events.add(report);
        if (add && this.scheduledJob == null) {
            this.scheduleJob();
        }
    }

    public void done(IJobChangeEvent event) {
        this.scheduledJob = null;
        if (!this.events.isEmpty()) {
            this.scheduleJob();
        }
    }

    @VisibleForTesting
    protected void scheduleJob() {
        this.scheduledJob = new UploadJob(this.events, this.settings, this.configuration, this.server, this.bus);
        this.scheduledJob.addJobChangeListener((IJobChangeListener)this);
        this.scheduledJob.schedule();
    }
}

