/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.eventbus.EventBus;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.logging.aeri.ui.Events;
import org.eclipse.epp.internal.logging.aeri.ui.ExpiringReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.log.ActiveShellPredicate;
import org.eclipse.epp.internal.logging.aeri.ui.log.PredicateDebugDecorator;
import org.eclipse.epp.internal.logging.aeri.ui.log.ProblemsDatabaseService;
import org.eclipse.epp.internal.logging.aeri.ui.log.ReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.log.ReportPredicates;
import org.eclipse.epp.internal.logging.aeri.ui.log.StandInStacktraceProvider;
import org.eclipse.epp.internal.logging.aeri.ui.log.StatusPredicates;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerConfiguration;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class LogListener
implements ILogListener {
    private StandInStacktraceProvider stacktraceProvider = new StandInStacktraceProvider();
    private Predicate<IStatus> statusFilters;
    private Predicate<ErrorReport> reportFilters;
    private EventBus bus;
    private Settings settings;
    private ServerConfiguration configuration;

    @VisibleForTesting
    public static LogListener createLogListener(Settings settings, ServerConfiguration configuration, ReportHistory history, EventBus bus, ExpiringReportHistory expiringReportHistory, ProblemsDatabaseService serverProblemsStatusIndex) {
        Predicate<T>[] statusPredicates = LogListener.decorateForDebug(new StatusPredicates.AcceptProductPredicate(configuration), new StatusPredicates.EclipseBuildIdPresentPredicate(), new StatusPredicates.ErrorStatusOnlyPredicate(), new ActiveShellPredicate(), new StatusPredicates.HistoryReadyPredicate(history), new StatusPredicates.IgnorePatternPredicate(configuration.getIgnoredPluginMessagesPatterns()), new StatusPredicates.ReporterNotDisabledPredicate(settings), new StatusPredicates.WhitelistedPluginIdPresentPredicate(configuration), new StatusPredicates.WorkbenchRunningPredicate(PlatformUI.getWorkbench()));
        Predicate statusFilters = Predicates.and(statusPredicates);
        Predicate<T>[] reportPredicates = LogListener.decorateForDebug(new ReportPredicates.AcceptOtherPackagesPredicate(configuration), new ReportPredicates.AcceptUiFreezesPredicate(configuration), new ReportPredicates.CompleteUiFreezeReportPredicate(), new ReportPredicates.ProblemDatabaseIgnoredPredicate(serverProblemsStatusIndex, settings), new ReportPredicates.ReportsHistoryPredicate(expiringReportHistory, settings), new ReportPredicates.UnseenErrorReportPredicate(history, settings), new ReportPredicates.ValidSizeErrorReportPredicate(configuration));
        Predicate reportFilters = Predicates.and(reportPredicates);
        LogListener listener = new LogListener((Predicate<IStatus>)statusFilters, (Predicate<ErrorReport>)reportFilters, settings, configuration, bus);
        return listener;
    }

    private static <T> Predicate<? super T>[] decorateForDebug(Predicate<? super T> ... components) {
        ILog log = Platform.getLog((Bundle)FrameworkUtil.getBundle(LogListener.class));
        Predicate[] predicates = new Predicate[components.length];
        int i = 0;
        while (i < components.length) {
            predicates[i] = new PredicateDebugDecorator<T>(components[i], log);
            ++i;
        }
        return predicates;
    }

    public LogListener(Predicate<IStatus> statusFilters, Predicate<ErrorReport> reportFilters, Settings settings, ServerConfiguration configuration, EventBus bus) {
        this.statusFilters = statusFilters;
        this.reportFilters = reportFilters;
        this.settings = settings;
        this.configuration = configuration;
        this.bus = bus;
    }

    public void logging(IStatus status, String nouse) {
        assert (status != null);
        try {
            if (!this.statusFilters.apply((Object)status)) {
                return;
            }
            ErrorReport report = this.createErrorReport(status);
            if (!this.reportFilters.apply((Object)report)) {
                return;
            }
            this.bus.post((Object)new Events.NewReportLogged(report));
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private ErrorReport createErrorReport(IStatus status) {
        ErrorReport report = Reports.newErrorReport(status, this.settings, this.configuration);
        this.insertStandinStacktrace(report);
        Reports.guessInvolvedPlugins(report);
        Reports.insertErrorAnalyseComment(report);
        return report;
    }

    private void insertStandinStacktrace(ErrorReport report) {
        this.stacktraceProvider.insertStandInStacktraceIfEmpty(report.getStatus(), this.configuration);
    }
}

