/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ProblemStatus;
import org.eclipse.epp.internal.logging.aeri.ui.model.Reports;

public class ProblemsDatabaseService
extends AbstractIdleService {
    private static final String F_MESSAGE = "message";
    private static final String F_ACTION = "action";
    private static final String F_BUG_ID = "bugId";
    private static final String F_BUG_URL = "bugUrl";
    private static final String F_PROBLEM_URL = "problemUrl";
    private static final String F_FINGERPRINT = "fingerprint";
    private File indexDirectory;
    private Directory index;
    private IndexReader reader;
    private IndexSearcher searcher;

    public ProblemsDatabaseService(File indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public Optional<ProblemStatus> seen(ErrorReport report) {
        if (!this.isRunning()) {
            return Optional.absent();
        }
        String fingerprint = Reports.traceIdentityHash(report);
        return this.seen((Query)new TermQuery(new Term(F_FINGERPRINT, fingerprint)));
    }

    private Optional<ProblemStatus> seen(Query q) {
        try {
            this.renewReaderAndSearcher();
            TopDocs results = this.searcher.search(q, 1);
            if (results.totalHits > 0) {
                int doc = results.scoreDocs[0].doc;
                Document d = this.reader.document(doc);
                ProblemStatus status = this.loadStatus(d);
                return Optional.of((Object)status);
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_STATUS_INDEX_NOT_AVAILABLE, e);
        }
        return Optional.absent();
    }

    private ProblemStatus loadStatus(Document d) {
        ProblemStatus status = new ProblemStatus();
        String stacktraceFingerprint = d.get(F_FINGERPRINT);
        status.setIncidentFingerprint(stacktraceFingerprint);
        String bugId = d.get(F_BUG_ID);
        if (StringUtils.isNotBlank((CharSequence)bugId)) {
            int id = Integer.parseInt(bugId);
            String url = d.get(F_BUG_URL);
            status.setBugId(id);
            status.setBugUrl(url);
        }
        String problemUrl = d.get(F_PROBLEM_URL);
        status.setProblemUrl(problemUrl);
        ProblemStatus.RequiredAction action = ProblemStatus.RequiredAction.valueOf(d.get(F_ACTION));
        status.setAction(action);
        String message = d.get(F_MESSAGE);
        if (StringUtils.isNotBlank((CharSequence)message)) {
            status.setMessage(message);
        }
        return status;
    }

    protected void startUp() throws Exception {
        this.index = this.createIndexDirectory();
        this.createReaderAndSearcher();
    }

    @VisibleForTesting
    protected Directory createIndexDirectory() throws IOException {
        this.indexDirectory.mkdirs();
        FSDirectory directory = FSDirectory.open((File)this.indexDirectory);
        if (!IndexReader.indexExists((Directory)directory)) {
            this.createInitialIndex((Directory)directory);
        }
        return directory;
    }

    private void createInitialIndex(Directory directory) throws IOException {
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)new KeywordAnalyzer());
        conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        Throwable throwable = null;
        Object var4_5 = null;
        try (IndexWriter writer = new IndexWriter(directory, conf);){
            Document meta = new Document();
            meta.add((Fieldable)new Field("version", "0.6", Field.Store.YES, Field.Index.NO));
            writer.addDocument(meta);
            writer.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createReaderAndSearcher() throws CorruptIndexException, IOException {
        this.reader = IndexReader.open((Directory)this.index);
        this.searcher = new IndexSearcher(this.reader);
    }

    protected void renewReaderAndSearcher() throws IOException {
        IndexReader tmp = IndexReader.openIfChanged((IndexReader)this.reader);
        if (tmp != null) {
            IOUtils.close((Closeable[])new Closeable[]{this.reader, this.searcher});
            this.searcher = new IndexSearcher(tmp);
            this.reader = tmp;
        }
    }

    protected void shutDown() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{this.searcher, this.reader, this.index});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replaceContent(File tempDir) throws IOException {
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)new KeywordAnalyzer());
        conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            IndexWriter writer = new IndexWriter(this.index, conf);
            try {
                try (FSDirectory newContent = FSDirectory.open((File)tempDir);){
                    writer.deleteAll();
                    writer.addIndexes(new Directory[]{newContent});
                    writer.commit();
                }
                if (writer == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            writer.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public File getIndexDirectory() {
        return this.indexDirectory;
    }
}

