/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import com.google.common.io.Files;
import java.io.File;
import java.util.concurrent.CancellationException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.log.ProblemsDatabaseService;
import org.eclipse.epp.internal.logging.aeri.ui.model.RememberSendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Zips;
import org.eclipse.epp.internal.logging.aeri.ui.v2.AeriServer;

public class ProblemsDatabaseUpdateJob
extends Job {
    private ProblemsDatabaseService service;
    private AeriServer server;
    private Settings settings;

    public ProblemsDatabaseUpdateJob(ProblemsDatabaseService service, AeriServer server, Settings settings) {
        super("Updating Error Reports Database");
        this.service = service;
        this.server = server;
        this.settings = settings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        progress.beginTask("Checking...", 1000);
        if (!this.server.isProblemsDatabaseOutdated()) {
            return Status.OK_STATUS;
        }
        try {
            progress.subTask("Checking remote database");
            File tempRemoteIndexZip = File.createTempFile("problems-index", ".zip");
            int downloadStatus = this.server.downloadDatabase(tempRemoteIndexZip, (IProgressMonitor)progress);
            if (downloadStatus == 304) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (downloadStatus != 200) {
                this.settings.setAction(SendAction.IGNORE);
                this.settings.setRememberSendAction(RememberSendAction.RESTART);
                Logs.log(LogMessages.INFO_SERVER_NOT_AVAILABLE);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            progress.worked(1);
            File tempDir = Files.createTempDir();
            progress.subTask("Replacing local database");
            Zips.unzip(tempRemoteIndexZip, tempDir);
            this.service.replaceContent(tempDir);
            progress.worked(1);
            tempRemoteIndexZip.delete();
            FileUtils.deleteDirectory((File)tempDir);
            progress.worked(1);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CancellationException cancellationException) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_INDEX_UPDATE_FAILED, e);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

