/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import org.eclipse.epp.internal.logging.aeri.ui.ExpiringReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.log.ProblemsDatabaseService;
import org.eclipse.epp.internal.logging.aeri.ui.log.ReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.model.Bundle;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ProblemStatus;
import org.eclipse.epp.internal.logging.aeri.ui.model.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.model.StackTraceElement;
import org.eclipse.epp.internal.logging.aeri.ui.model.Status;
import org.eclipse.epp.internal.logging.aeri.ui.model.Throwable;
import org.eclipse.epp.internal.logging.aeri.ui.model.util.ModelSwitch;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerConfiguration;

public class ReportPredicates {
    private static boolean isUiMonitoring(Status status) {
        return Objects.equal((Object)"org.eclipse.ui.monitoring", (Object)status.getPluginId());
    }

    public static class AcceptOtherPackagesPredicate
    implements Predicate<ErrorReport> {
        private ServerConfiguration configuration;

        public AcceptOtherPackagesPredicate(ServerConfiguration configuration) {
            this.configuration = configuration;
        }

        public boolean apply(ErrorReport report) {
            return this.configuration.isAcceptOtherPackages() || !Reports.containsNotWhitelistedClasses(report, this.configuration);
        }
    }

    public static class AcceptUiFreezesPredicate
    implements Predicate<ErrorReport> {
        private ServerConfiguration configuration;

        public AcceptUiFreezesPredicate(ServerConfiguration configuration) {
            this.configuration = configuration;
        }

        public boolean apply(ErrorReport report) {
            return this.configuration.isAcceptUiFreezes() || !ReportPredicates.isUiMonitoring(report.getStatus());
        }
    }

    public static class CompleteUiFreezeReportPredicate
    implements Predicate<ErrorReport> {
        public boolean apply(ErrorReport report) {
            Status status = report.getStatus();
            return ReportPredicates.isUiMonitoring(status) ? !status.getChildren().isEmpty() : true;
        }
    }

    public static class ProblemDatabaseIgnoredPredicate
    implements Predicate<ErrorReport> {
        private ProblemsDatabaseService index;
        private Settings settings;

        public ProblemDatabaseIgnoredPredicate(ProblemsDatabaseService index, Settings settings) {
            this.index = index;
            this.settings = settings;
        }

        public boolean apply(ErrorReport report) {
            if (!this.settings.isSkipSimilarErrors()) {
                return true;
            }
            Optional<ProblemStatus> status = this.index.seen(report);
            return !status.isPresent() || ((ProblemStatus)status.get()).getAction() != ProblemStatus.RequiredAction.IGNORE;
        }
    }

    public static class ReportsHistoryPredicate
    implements Predicate<ErrorReport> {
        private ExpiringReportHistory history;
        private Settings settings;

        public ReportsHistoryPredicate(ExpiringReportHistory history, Settings settings) {
            this.history = history;
            this.settings = settings;
        }

        public boolean apply(ErrorReport report) {
            boolean seen;
            if (!this.settings.isSkipSimilarErrors()) {
                return true;
            }
            boolean bl = seen = this.history.seenExact(report) || this.history.seenSimilarTrace(report);
            if (!seen) {
                this.history.add(report);
            }
            return !seen;
        }
    }

    public static class UnseenErrorReportPredicate
    implements Predicate<ErrorReport> {
        private ReportHistory history;
        private Settings settings;

        public UnseenErrorReportPredicate(ReportHistory history, Settings settings) {
            this.history = history;
            this.settings = settings;
        }

        public boolean apply(ErrorReport report) {
            if (!this.settings.isSkipSimilarErrors()) {
                return true;
            }
            if (!this.history.isRunning()) {
                Logs.log(LogMessages.WARN_HISTORY_NOT_AVAILABLE);
                return true;
            }
            return !this.history.seenSimilar(report) && !this.history.seen(report);
        }
    }

    public static class ValidSizeErrorReportPredicate
    implements Predicate<ErrorReport> {
        private ServerConfiguration configuration;

        public ValidSizeErrorReportPredicate(ServerConfiguration configuration) {
            this.configuration = configuration;
        }

        public boolean apply(ErrorReport report) {
            EstimateSizeVisitor visitor = new EstimateSizeVisitor();
            Reports.visit(report, visitor);
            int estimatedByteLength = visitor.estimatedCharacters * 2;
            return estimatedByteLength < this.configuration.getMaxReportSize();
        }

        private static final class EstimateSizeVisitor
        extends ModelSwitch<Object> {
            int estimatedCharacters = 0;

            private EstimateSizeVisitor() {
            }

            @Override
            public Object caseStatus(Status status) {
                if (status != null) {
                    this.estimatedCharacters += status.getPluginId().length();
                    this.estimatedCharacters += status.getMessage().length();
                }
                return null;
            }

            @Override
            public Object caseThrowable(Throwable throwable) {
                if (throwable.getMessage() != null) {
                    this.estimatedCharacters += throwable.getMessage().length();
                }
                return null;
            }

            @Override
            public Object caseStackTraceElement(StackTraceElement element) {
                this.estimatedCharacters += element.getClassName().length();
                String fileName = element.getFileName();
                if (fileName != null) {
                    this.estimatedCharacters += fileName.length();
                }
                this.estimatedCharacters += element.getMethodName().length();
                return null;
            }

            @Override
            public Object caseBundle(Bundle bundle) {
                this.estimatedCharacters += bundle.getName().length();
                this.estimatedCharacters += bundle.getVersion().length();
                return null;
            }
        }
    }
}

