/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ui.log.ReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerConfiguration;
import org.eclipse.ui.IWorkbench;

public class StatusPredicates {

    public static class AcceptProductPredicate
    implements Predicate<IStatus> {
        private ServerConfiguration configuration;

        public AcceptProductPredicate(ServerConfiguration configuration) {
            this.configuration = configuration;
        }

        public boolean apply(IStatus input) {
            String product = System.getProperty("eclipse.product");
            return product == null ? false : this.isAccepted(product);
        }

        private boolean isAccepted(String product) {
            for (Pattern acceptedProductPattern : this.configuration.getAcceptedProductsPatterns()) {
                if (!acceptedProductPattern.matcher(product).matches()) continue;
                return true;
            }
            return false;
        }
    }

    public static class EclipseBuildIdPresentPredicate
    implements Predicate<IStatus> {
        public boolean apply(IStatus input) {
            return !StringUtils.isEmpty((CharSequence)System.getProperty("eclipse.buildId"));
        }
    }

    public static class ErrorStatusOnlyPredicate
    implements Predicate<IStatus> {
        public boolean apply(IStatus input) {
            return input.matches(4);
        }
    }

    public static class HistoryReadyPredicate
    implements Predicate<IStatus> {
        private ReportHistory history;

        public HistoryReadyPredicate(ReportHistory history) {
            this.history = history;
        }

        public boolean apply(IStatus input) {
            return this.history.isRunning();
        }
    }

    public static class IgnorePatternPredicate
    implements Predicate<IStatus> {
        private List<ServerConfiguration.IgnorePattern> patterns;

        public IgnorePatternPredicate(List<ServerConfiguration.IgnorePattern> patterns) {
            this.patterns = patterns;
        }

        public boolean apply(IStatus input) {
            for (ServerConfiguration.IgnorePattern pattern : this.patterns) {
                if (!pattern.matches(input)) continue;
                return false;
            }
            return true;
        }
    }

    public static class ReporterNotDisabledPredicate
    implements Predicate<IStatus> {
        private Settings settings;

        public ReporterNotDisabledPredicate(Settings settings) {
            this.settings = settings;
        }

        public boolean apply(IStatus input) {
            return !Objects.equal((Object)((Object)SendAction.IGNORE), (Object)((Object)this.settings.getAction()));
        }
    }

    public static class WhitelistedPluginIdPresentPredicate
    implements Predicate<IStatus> {
        private ServerConfiguration configuration;

        public WhitelistedPluginIdPresentPredicate(ServerConfiguration configuration) {
            this.configuration = configuration;
        }

        public boolean apply(IStatus input) {
            String pluginId = input.getPlugin();
            for (Pattern id : this.configuration.getAcceptedPluginsPatterns()) {
                if (!id.matcher(pluginId).matches()) continue;
                return true;
            }
            return false;
        }
    }

    public static class WorkbenchRunningPredicate
    implements Predicate<IStatus> {
        private IWorkbench workbench;

        public WorkbenchRunningPredicate(IWorkbench workbench) {
            this.workbench = workbench;
        }

        public boolean apply(IStatus input) {
            return !this.workbench.isClosing();
        }
    }
}

