/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.model.Bundle;
import org.eclipse.epp.internal.logging.aeri.ui.model.Throwable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ErrorAnalyser {
    private final PackageAdmin packageAdmin;

    public ErrorAnalyser() {
        this.packageAdmin = (PackageAdmin)this.getService(PackageAdmin.class).orNull();
    }

    @VisibleForTesting
    protected ErrorAnalyser(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    protected <T> Optional<T> getService(Class<T> serviceClass) {
        if (LogMessages.BUNDLE == null) {
            return Optional.absent();
        }
        BundleContext context = LogMessages.BUNDLE.getBundleContext();
        if (context == null) {
            return Optional.absent();
        }
        ServiceReference reference = context.getServiceReference(serviceClass);
        if (reference == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)context.getService(reference));
    }

    public Optional<String> computeComment(List<Bundle> presentBundles, Throwable throwable) {
        if (this.packageAdmin == null) {
            return Optional.absent();
        }
        List<String> problematicPackages = ErrorAnalyser.extractProblematicPackage(throwable);
        if (problematicPackages.isEmpty()) {
            return Optional.absent();
        }
        HashSet presentBundlesSymbolicNames = Sets.newHashSet();
        for (Bundle presentBundle : presentBundles) {
            presentBundlesSymbolicNames.add(presentBundle.getName());
        }
        StringBuilder comment = new StringBuilder();
        for (String problematicPackage : problematicPackages) {
            comment.append("The problematic package '").append(problematicPackage).append("' may originate in the following bundles:\n");
            Object[] exportedPackages = this.packageAdmin.getExportedPackages(problematicPackage);
            if (ArrayUtils.isEmpty((Object[])exportedPackages)) continue;
            HashMultimap exportersToImporters = HashMultimap.create();
            Object[] objectArray = exportedPackages;
            int n = exportedPackages.length;
            int n2 = 0;
            while (n2 < n) {
                Object exportedPackage = objectArray[n2];
                org.osgi.framework.Bundle exportingBundle = exportedPackage.getExportingBundle();
                if (this.isPresent(exportingBundle)) {
                    org.osgi.framework.Bundle[] bundleArray = exportedPackage.getImportingBundles();
                    int n3 = bundleArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        org.osgi.framework.Bundle importingBundle = bundleArray[n4];
                        if (this.isPresent(importingBundle) && presentBundlesSymbolicNames.contains(importingBundle.getSymbolicName())) {
                            exportersToImporters.put((Object)exportingBundle, (Object)importingBundle);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (exportersToImporters.isEmpty()) continue;
            for (Map.Entry entry : exportersToImporters.asMap().entrySet()) {
                org.osgi.framework.Bundle exporter = (org.osgi.framework.Bundle)entry.getKey();
                Collection importers = (Collection)entry.getValue();
                comment.append("  ").append(exporter.getSymbolicName()).append(' ').append(exporter.getVersion()).append(", from which the following bundles present on the stack trace import it:\n");
                for (org.osgi.framework.Bundle importer : importers) {
                    comment.append("    ").append(importer.getSymbolicName()).append(' ').append(importer.getVersion()).append('\n');
                }
            }
        }
        return Optional.of((Object)comment.toString());
    }

    private boolean isPresent(org.osgi.framework.Bundle bundle) {
        switch (bundle.getState()) {
            case 4: 
            case 8: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    static List<String> extractProblematicPackage(Throwable throwable) {
        String message = throwable.getMessage();
        if (StringUtils.equals((CharSequence)"HIDDEN", (CharSequence)message)) {
            return Lists.newArrayList();
        }
        if (NoClassDefFoundError.class.getName().equals(throwable.getClassName()) || LinkageError.class.getName().equals(throwable.getClassName())) {
            return ErrorAnalyser.handleNoClassDefFoundErrorAndLinkageError(message);
        }
        if (ClassNotFoundException.class.getName().equals(throwable.getClassName())) {
            return ErrorAnalyser.handleClassNotFoundException(message);
        }
        if (NoSuchMethodError.class.getName().equals(throwable.getClassName())) {
            return ErrorAnalyser.handleMethodNotFoundException(message);
        }
        if (VerifyError.class.getName().equals(throwable.getClassName())) {
            return ErrorAnalyser.handleVerifyError(message);
        }
        return Lists.newArrayList();
    }

    private static List<String> handleVerifyError(String message) {
        ArrayList packages = Lists.newArrayList();
        Pattern pattern = Pattern.compile("'([\\S]*)'");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String clazz = matcher.group(1);
            int lastIndexOfSlash = clazz.lastIndexOf(47);
            if (lastIndexOfSlash == -1) continue;
            String packageName = clazz.substring(0, lastIndexOfSlash);
            if (packages.contains(packageName = packageName.replaceAll("/", "."))) continue;
            packages.add(packageName);
        }
        return packages;
    }

    private static List<String> handleNoClassDefFoundErrorAndLinkageError(String message) {
        int lastIndexOfSlash = message.lastIndexOf(47);
        if (lastIndexOfSlash < 0) {
            return Lists.newArrayList();
        }
        String packageName = message.substring(0, lastIndexOfSlash).replace('/', '.');
        return Lists.newArrayList((Object[])new String[]{packageName});
    }

    private static List<String> handleClassNotFoundException(String message) {
        int lastIndexOfDot;
        int firstIndexOfSpace = message.indexOf(" ");
        if (firstIndexOfSpace >= 0) {
            message = message.substring(0, firstIndexOfSpace);
        }
        if ((lastIndexOfDot = message.lastIndexOf(46)) < 0) {
            return Lists.newArrayList();
        }
        String packageName = message.substring(0, lastIndexOfDot);
        return Lists.newArrayList((Object[])new String[]{packageName});
    }

    private static List<String> handleMethodNotFoundException(String message) {
        String className = StringUtils.substringBeforeLast((String)message, (String)".");
        String packageName = StringUtils.substringBeforeLast((String)className, (String)".");
        return Lists.newArrayList((Object[])new String[]{packageName});
    }
}

