/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.model;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.model.ModelFactory;
import org.eclipse.epp.internal.logging.aeri.ui.model.ModelPackage;
import org.eclipse.epp.internal.logging.aeri.ui.model.RememberSendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public static final ModelPackage PKG = ModelPackage.eINSTANCE;
    public static final String PROP_ANONYMIZE_STACKTRACES = PKG.getSettings_AnonymizeStrackTraceElements().getName();
    public static final String PROP_ANONYMIZE_MESSAGES = PKG.getSettings_AnonymizeMessages().getName();
    public static final String PROP_CONFIGURED = PKG.getSettings_Configured().getName();
    public static final String PROP_EMAIL = PKG.getSettings_Email().getName();
    public static final String PROP_NAME = PKG.getSettings_Name().getName();
    public static final String PROP_REMEMBER_SEND_ACTION = PKG.getSettings_RememberSendAction().getName();
    public static final String PROP_REMEMBER_SETTING_PERIOD_START = PKG.getSettings_RememberSendActionPeriodStart().getName();
    public static final String PROP_SEND_ACTION = PKG.getSettings_Action().getName();
    public static final String PROP_SERVER = PKG.getSettings_ServerUrl().getName();
    public static final String PROP_SKIP_SIMILAR_ERRORS = PKG.getSettings_SkipSimilarErrors().getName();
    public static final String PROP_SERVER_CONFIGURATION_LOCAL_FILE = PKG.getSettings_ServerConfigurationLocalFile().getName();
    public static final String SERVER_URL = PreferenceInitializer.getServerUrl();
    public static final String SERVER_CONFIGURATION_FILE;
    private static long MS_PER_DAY;
    private static Settings settings;

    static {
        Bundle bundle = FrameworkUtil.getBundle(PreferenceInitializer.class);
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        File indexDirectory = new File(stateLocation.toFile(), "server-config.json");
        SERVER_CONFIGURATION_FILE = indexDirectory.getAbsolutePath();
        MS_PER_DAY = TimeUnit.DAYS.toMillis(1L);
    }

    private static String getServerUrl() {
        return System.getProperty("org.eclipse.epp.logging.aeri.ui." + PROP_SERVER, "https://dev.eclipse.org/recommenders/community/confess/v2/discovery");
    }

    public void initializeDefaultPreferences() {
        IEclipsePreferences s = DefaultScope.INSTANCE.getNode("org.eclipse.epp.logging.aeri.ui");
        String name = "";
        String email = "";
        boolean anonymizeStacktraces = true;
        boolean anonymizeMessages = false;
        try {
            ScopedPreferenceStore store = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "org.eclipse.epp.logging.aeri.ui");
            name = store.getString(PROP_NAME);
            email = store.getString(PROP_EMAIL);
            if (store.contains(PROP_ANONYMIZE_STACKTRACES)) {
                anonymizeStacktraces = store.getBoolean(PROP_ANONYMIZE_STACKTRACES);
            }
            if (store.contains(PROP_ANONYMIZE_MESSAGES)) {
                anonymizeMessages = store.getBoolean(PROP_ANONYMIZE_MESSAGES);
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_FAILED_TO_LOAD_DEFAULT_PREFERENCES, e);
        }
        s.put(PROP_SERVER, SERVER_URL);
        s.put(PROP_SERVER_CONFIGURATION_LOCAL_FILE, SERVER_CONFIGURATION_FILE);
        s.put(PROP_NAME, name);
        s.put(PROP_EMAIL, email);
        s.putBoolean(PROP_ANONYMIZE_STACKTRACES, anonymizeStacktraces);
        s.putBoolean(PROP_ANONYMIZE_MESSAGES, anonymizeMessages);
        s.putBoolean(PROP_SKIP_SIMILAR_ERRORS, true);
        s.putBoolean(PROP_CONFIGURED, false);
        s.putLong(PROP_REMEMBER_SETTING_PERIOD_START, 0L);
        s.put(PROP_SEND_ACTION, SendAction.ASK.name());
        s.put(PROP_REMEMBER_SEND_ACTION, RememberSendAction.NONE.name());
    }

    public static Settings getDefault() {
        if (settings == null) {
            settings = ModelFactory.eINSTANCE.createSettings();
            EClass eClass = settings.eClass();
            ScopedPreferenceStore instanceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.epp.logging.aeri.ui");
            PreferenceInitializer.loadFromPreferences(instanceStore, settings, eClass);
            PreferenceInitializer.registerPreferenceStoreChangeListener(instanceStore, settings, eClass);
            PreferenceInitializer.registerSettingsChangeListener(instanceStore, settings, new HashSet<String>());
            ScopedPreferenceStore configurationStore = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "org.eclipse.epp.logging.aeri.ui");
            PreferenceInitializer.registerSettingsChangeListener(configurationStore, settings, (Set<String>)ImmutableSet.of((Object)PROP_NAME, (Object)PROP_EMAIL, (Object)PROP_ANONYMIZE_STACKTRACES, (Object)PROP_ANONYMIZE_MESSAGES));
            PreferenceInitializer.handleRestart24hSendAction(settings);
        }
        return settings;
    }

    private static void registerSettingsChangeListener(final ScopedPreferenceStore store, Settings settings, final Set<String> allowedKeys) {
        settings.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                Object feature = msg.getFeature();
                if (!(feature instanceof EAttribute)) {
                    return;
                }
                EAttribute attr = (EAttribute)feature;
                String key = attr.getName();
                EDataType type = attr.getEAttributeType();
                Object value = msg.getNewValue();
                String data = EcoreUtil.convertToString((EDataType)type, (Object)value);
                if (allowedKeys.isEmpty() || allowedKeys.contains(key)) {
                    try {
                        store.putValue(key, data);
                        store.save();
                    }
                    catch (Exception e) {
                        Logs.log((Logs.ILogMessage)LogMessages.ERROR_SAVE_PREFERENCES_FAILED, e);
                    }
                }
            }
        });
    }

    private static void registerPreferenceStoreChangeListener(ScopedPreferenceStore store, final Settings settings, final EClass eClass) {
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                EStructuralFeature feature = eClass.getEStructuralFeature(property);
                if (feature != null && feature instanceof EAttribute) {
                    EAttribute attr = (EAttribute)feature;
                    EDataType type = attr.getEAttributeType();
                    String string = EcoreUtil.convertToString((EDataType)type, (Object)event.getNewValue());
                    Object value = EcoreUtil.createFromString((EDataType)type, (String)string);
                    settings.eSet(feature, value);
                }
            }
        });
    }

    private static void loadFromPreferences(ScopedPreferenceStore store, Settings settings, EClass eClass) {
        settings.eSetDeliver(false);
        for (EAttribute attr : eClass.getEAllAttributes()) {
            EDataType type = attr.getEAttributeType();
            String key = attr.getName();
            String value = store.getString(key);
            try {
                Object data = EcoreUtil.createFromString((EDataType)type, (String)value);
                settings.eSet((EStructuralFeature)attr, data);
            }
            catch (Exception exception) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_PARSE_PREFERENCE_VALUE, attr, value);
            }
        }
        settings.eSetDeliver(true);
    }

    static void handleRestart24hSendAction(Settings settings) {
        switch (settings.getRememberSendAction()) {
            case RESTART: {
                settings.setAction(SendAction.ASK);
                settings.setRememberSendAction(RememberSendAction.NONE);
                break;
            }
            case HOURS_24: {
                boolean isDayElapsed;
                long elapsedTime = System.currentTimeMillis() - settings.getRememberSendActionPeriodStart();
                boolean bl = isDayElapsed = elapsedTime >= MS_PER_DAY;
                if (!isDayElapsed) break;
                Logs.log(LogMessages.INFO_PAUSE_PERIOD_ELAPSED);
                settings.setAction(SendAction.ASK);
                settings.setRememberSendAction(RememberSendAction.NONE);
            }
        }
    }

    static List<String> convert(String string) {
        return Splitter.on((char)';').omitEmptyStrings().trimResults().splitToList((CharSequence)string);
    }

    static String convert(List<String> strings) {
        return Joiner.on((String)";").skipNulls().join(strings);
    }
}

