/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.model.Bundle;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorAnalyser;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ModelFactory;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.model.StackTraceElement;
import org.eclipse.epp.internal.logging.aeri.ui.model.Status;
import org.eclipse.epp.internal.logging.aeri.ui.model.Throwable;
import org.eclipse.epp.internal.logging.aeri.ui.model.util.ModelSwitch;
import org.eclipse.epp.internal.logging.aeri.ui.utils.AnonymousId;
import org.eclipse.epp.internal.logging.aeri.ui.utils.EmfFieldExclusionStrategy;
import org.eclipse.epp.internal.logging.aeri.ui.utils.UuidTypeAdapter;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerConfiguration;

public class Reports {
    private static ModelFactory factory = ModelFactory.eINSTANCE;

    static boolean isWhitelisted(String className, List<Pattern> whitelist) {
        for (Pattern whitelistedPattern : whitelist) {
            if (!whitelistedPattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }

    public static ErrorReport copy(ErrorReport org) {
        return (ErrorReport)EcoreUtil.copy((EObject)org);
    }

    public static String toJson(ErrorReport report, boolean pretty) {
        Gson gson = Reports.createGson(pretty);
        String json = gson.toJson((Object)report);
        return json;
    }

    public static ErrorReport createAnonymizedSendCopy(ErrorReport report, Settings settings, ServerConfiguration configuration) {
        ErrorReport copy = Reports.copy(report);
        copy.setName(settings.getName());
        copy.setEmail(settings.getEmail());
        if (settings.isAnonymizeStrackTraceElements()) {
            Reports.anonymizeStackTrace(copy, configuration);
        }
        if (settings.isAnonymizeMessages()) {
            Reports.clearMessages(copy);
        }
        return copy;
    }

    private static Gson createGson(boolean pretty) {
        GsonBuilder builder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        builder.registerTypeAdapter(UUID.class, (Object)new UuidTypeAdapter());
        builder.addSerializationExclusionStrategy((ExclusionStrategy)new EmfFieldExclusionStrategy());
        if (pretty) {
            builder.setPrettyPrinting();
        }
        Gson gson = builder.create();
        return gson;
    }

    public static ErrorReport newErrorReport(IStatus event, Settings settings, ServerConfiguration configuration) {
        ErrorReport mReport = factory.createErrorReport();
        mReport.setAnonymousId(AnonymousId.getId());
        mReport.setName(settings.getName());
        mReport.setEmail(settings.getEmail());
        mReport.setJavaRuntimeVersion(SystemUtils.JAVA_RUNTIME_VERSION);
        mReport.setEclipseBuildId((String)Reports.getEclipseBuildId().or((Object)"-"));
        mReport.setEclipseProduct(System.getProperty("eclipse.product", "-"));
        mReport.setOsgiArch(System.getProperty("osgi.arch", "-"));
        mReport.setOsgiWs(System.getProperty("osgi.ws", "-"));
        mReport.setOsgiOs(System.getProperty("org.osgi.framework.os.name", "-"));
        mReport.setOsgiOsVersion(System.getProperty("org.osgi.framework.os.version", "-"));
        mReport.setStatus(Reports.newStatus(event, configuration));
        return mReport;
    }

    public static Optional<String> getEclipseBuildId() {
        String res = System.getProperty("eclipse.buildId");
        return Optional.fromNullable((Object)res);
    }

    public static void guessInvolvedPlugins(ErrorReport report) {
        CollectStackTraceElementPackagesVisitor v = new CollectStackTraceElementPackagesVisitor();
        Reports.visit(report, v);
        HashSet uniqueBundleNames = Sets.newHashSet();
        for (String packageName : v.packages) {
            while (packageName.contains(".")) {
                org.osgi.framework.Bundle guessedBundleForPackageName = Platform.getBundle((String)packageName);
                packageName = StringUtils.substringBeforeLast((String)packageName, (String)".");
                if (guessedBundleForPackageName == null || !uniqueBundleNames.add(guessedBundleForPackageName.getSymbolicName())) continue;
                Bundle bundle = factory.createBundle();
                bundle.setName(guessedBundleForPackageName.getSymbolicName());
                bundle.setVersion(guessedBundleForPackageName.getVersion().toString());
                report.getPresentBundles().add((Object)bundle);
            }
        }
    }

    public static void insertErrorAnalyseComment(ErrorReport report) {
        ErrorAnalyserVisitor visitor = new ErrorAnalyserVisitor((List<Bundle>)report.getPresentBundles());
        Reports.visit(report, visitor);
        Optional<String> comment = visitor.getLinkageErrorComment();
        if (comment.isPresent()) {
            report.setComment((String)comment.get());
        }
    }

    @VisibleForTesting
    public static Status newStatus(IStatus status, ServerConfiguration configuration) {
        boolean needFiltering;
        java.lang.Throwable exception;
        Status mStatus = factory.createStatus();
        mStatus.setMessage(Reports.removeSourceFileContents(status.getMessage()));
        mStatus.setSeverity(status.getSeverity());
        mStatus.setCode(status.getCode());
        mStatus.setPluginId(status.getPlugin());
        org.osgi.framework.Bundle bundle = Platform.getBundle((String)status.getPlugin());
        if (bundle != null) {
            mStatus.setPluginVersion(bundle.getVersion().toString());
        }
        EList<Status> mChildren = mStatus.getChildren();
        java.lang.Throwable cur = exception = status.getException();
        while (cur != null) {
            if (cur instanceof CoreException) {
                CoreException coreException = (CoreException)cur;
                IStatus coreExceptionStatus = coreException.getStatus();
                Status mCoreExceptionStatus = Reports.newStatus(coreExceptionStatus, configuration);
                String detachedMessage = MessageFormat.format("{0} [detached from CoreException of Status ''{1}'' by Error Reporting]", mCoreExceptionStatus.getMessage(), mStatus.getMessage());
                mCoreExceptionStatus.setMessage(detachedMessage);
                mChildren.add(mCoreExceptionStatus);
                break;
            }
            cur = cur.getCause();
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int coreException = 0;
        while (coreException < n) {
            IStatus child = iStatusArray[coreException];
            mChildren.add(Reports.newStatus(child, configuration));
            ++coreException;
        }
        boolean bl = needFiltering = "org.eclipse.ui.monitoring".equals(status.getPlugin()) && (status.getCode() == 0 || status.getCode() == 1);
        if (needFiltering) {
            MultiStatusFilter.filter(mStatus);
        }
        if (exception != null) {
            Throwable mException = Reports.newThrowable(exception);
            mStatus.setException(mException);
        }
        mStatus.setFingerprint(Reports.computeFingerprintFor(mStatus, configuration));
        return mStatus;
    }

    public static String computeFingerprintFor(Status status, ServerConfiguration configuration) {
        ThrowableFingerprintComputer fingerprintComputer = new ThrowableFingerprintComputer(configuration.getAcceptedPackagesPatterns(), 1024);
        Reports.visit(status, fingerprintComputer);
        return fingerprintComputer.hash();
    }

    private static String removeSourceFileContents(String message) {
        if (message.contains("----------------------------------- SOURCE BEGIN -------------------------------------")) {
            return "source file contents removed";
        }
        return message;
    }

    public static Throwable newThrowable(java.lang.Throwable throwable) {
        Throwable mThrowable = factory.createThrowable();
        mThrowable.setMessage(throwable.getMessage());
        mThrowable.setClassName(throwable.getClass().getName());
        EList<StackTraceElement> mStackTrace = mThrowable.getStackTrace();
        java.lang.StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            StackTraceElement mStackTraceElement = factory.createStackTraceElement();
            mStackTraceElement.setFileName(stackTraceElement.getFileName());
            mStackTraceElement.setClassName(Reports.ensureNotBlank(stackTraceElement.getClassName(), throwable));
            mStackTraceElement.setMethodName(Reports.ensureNotBlank(stackTraceElement.getMethodName(), throwable));
            mStackTraceElement.setLineNumber(stackTraceElement.getLineNumber());
            mStackTrace.add(mStackTraceElement);
            ++n2;
        }
        java.lang.Throwable cause = throwable.getCause();
        if (cause != null) {
            if (cause == throwable) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_CYCLIC_EXCEPTION, cause.toString());
                return mThrowable;
            }
            mThrowable.setCause(Reports.newThrowable(cause));
        }
        return mThrowable;
    }

    private static String ensureNotBlank(String str, java.lang.Throwable throwable) {
        if (StringUtils.isBlank((CharSequence)str)) {
            Logs.log(LogMessages.WARN_STACKTRACE_WITH_NULL);
            return "MISSING";
        }
        return str;
    }

    public static void clearMessages(ErrorReport report) {
        Reports.visit(report, new ClearMessagesVisitor());
    }

    public static void anonymizeStackTrace(ErrorReport report, ServerConfiguration configuration) {
        Reports.visit(report, new AnonymizeStacktraceVisitor(configuration.getAcceptedPackagesPatterns()));
    }

    public static boolean containsNotWhitelistedClasses(ErrorReport report, ServerConfiguration configuration) {
        NotWhitelistedClassDetectorVisitor visitor = new NotWhitelistedClassDetectorVisitor(configuration.getAcceptedPackagesPatterns());
        Reports.visit(report, visitor);
        return visitor.isDetected();
    }

    public static String prettyPrint(ErrorReport report) {
        PrettyPrintVisitor prettyPrintVisitor = new PrettyPrintVisitor();
        Reports.visit(report, prettyPrintVisitor);
        return prettyPrintVisitor.print();
    }

    public static String getFingerprint(ErrorReport report) {
        return report.getStatus().getFingerprint();
    }

    public static <T, K extends EObject> T visit(K object, ModelSwitch<T> s) {
        TreeIterator allContents;
        Object t = s.doSwitch(object);
        if (t != null) {
            return (T)t;
        }
        TreeIterator iterator = allContents = EcoreUtil.getAllContents(object, (boolean)true);
        while (iterator.hasNext()) {
            EObject modelElement = (EObject)iterator.next();
            t = s.doSwitch(modelElement);
            if (t == null) continue;
            return (T)t;
        }
        return null;
    }

    public static String exactIdentityHash(ErrorReport report) {
        final Hasher hasher = Hashing.murmur3_128().newHasher();
        ModelSwitch<Hasher> s = new ModelSwitch<Hasher>(){

            @Override
            public Hasher caseErrorReport(ErrorReport object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getEclipseProduct()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getEclipseBuildId()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getJavaRuntimeVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiOs()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiOsVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiArch()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiWs()), Charsets.UTF_8);
                return null;
            }

            @Override
            public Hasher caseStatus(Status object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getPluginId()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getPluginVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                hasher.putInt(object.getSeverity());
                hasher.putInt(object.getCode());
                return null;
            }

            @Override
            public Hasher caseBundle(Bundle object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getVersion()), Charsets.UTF_8);
                return null;
            }

            @Override
            public Hasher caseStackTraceElement(StackTraceElement object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMethodName()), Charsets.UTF_8);
                hasher.putInt(object.getLineNumber());
                return null;
            }

            @Override
            public Hasher caseThrowable(Throwable object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                return null;
            }
        };
        Reports.visit(report, s);
        String hash = hasher.hash().toString();
        return hash;
    }

    public static String traceIdentityHash(ErrorReport report) {
        final Hasher hasher = Hashing.murmur3_128().newHasher();
        Reports.visit(report, new ModelSwitch<Hasher>(){

            @Override
            public Hasher caseStackTraceElement(StackTraceElement element) {
                hasher.putString((CharSequence)element.getClassName(), Charsets.UTF_8);
                hasher.putString((CharSequence)element.getMethodName(), Charsets.UTF_8);
                hasher.putInt(element.getLineNumber());
                return null;
            }
        });
        String hash = hasher.hash().toString();
        return hash;
    }

    public static String toShortClassName(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return "";
        }
        if (StringUtils.contains((CharSequence)className, (int)36)) {
            return StringUtils.substringAfterLast((String)className, (String)"$");
        }
        if (StringUtils.contains((CharSequence)className, (int)46)) {
            return StringUtils.substringAfterLast((String)className, (String)".");
        }
        return className;
    }

    public static final class AnonymizeStacktraceVisitor
    extends ModelSwitch<Object> {
        private List<Pattern> whitelist;

        public AnonymizeStacktraceVisitor(List<Pattern> whitelist) {
            this.whitelist = whitelist;
        }

        @Override
        public Object caseThrowable(Throwable throwable) {
            if (!Reports.isWhitelisted(throwable.getClassName(), this.whitelist)) {
                throwable.setClassName("HIDDEN");
            }
            return null;
        }

        @Override
        public Object caseStackTraceElement(StackTraceElement element) {
            if (!Reports.isWhitelisted(element.getClassName(), this.whitelist)) {
                element.setClassName("HIDDEN");
                element.setMethodName("HIDDEN");
                element.setFileName("HIDDEN");
                element.setLineNumber(-1);
            }
            return null;
        }
    }

    public static final class ClearMessagesVisitor
    extends ModelSwitch<Object> {
        @Override
        public Object caseStatus(Status status) {
            status.setMessage("HIDDEN");
            return null;
        }

        @Override
        public Object caseThrowable(Throwable throwable) {
            throwable.setMessage("HIDDEN");
            return null;
        }
    }

    public static final class CollectStackTraceElementPackagesVisitor
    extends ModelSwitch<Object> {
        public TreeSet<String> packages = Sets.newTreeSet();

        @Override
        public Object caseStackTraceElement(StackTraceElement element) {
            String pkg = StringUtils.replace((String)StringUtils.substringBeforeLast((String)element.getClassName(), (String)"."), (String)".internal.", (String)".");
            this.packages.add(pkg);
            return null;
        }
    }

    public static final class ErrorAnalyserVisitor
    extends ModelSwitch<Object> {
        private static final ErrorAnalyser ANALYSER = new ErrorAnalyser();
        private Optional<String> errorComment = Optional.absent();
        private final List<Bundle> presentBundles;

        public ErrorAnalyserVisitor(List<Bundle> presentBundles) {
            this.presentBundles = presentBundles;
        }

        @Override
        public Object caseThrowable(Throwable throwable) {
            this.errorComment = ANALYSER.computeComment(this.presentBundles, throwable);
            if (this.errorComment.isPresent()) {
                return Boolean.TRUE;
            }
            return null;
        }

        public Optional<String> getLinkageErrorComment() {
            return this.errorComment;
        }
    }

    private static class MultiStatusFilter {
        private MultiStatusFilter() {
        }

        private static void filter(Status status) {
            HashSet<Throwable> throwables = new HashSet<Throwable>();
            MultiStatusFilter.filter(status, throwables);
        }

        private static void filter(Status status, Set<Throwable> throwables) {
            EList<Status> children = status.getChildren();
            int removedCount = 0;
            int i = children.size() - 1;
            while (i >= 0) {
                Status childStatus = (Status)children.get(i);
                if (MultiStatusFilter.filterChild(childStatus, throwables)) {
                    children.remove(i);
                    ++removedCount;
                } else {
                    MultiStatusFilter.filter(childStatus, throwables);
                }
                --i;
            }
            if (removedCount > 0) {
                status.setMessage(String.format("%s [%d child-status duplicates removed by Error Reporting]", status.getMessage(), removedCount));
            }
        }

        private static boolean filterChild(Status status, Set<Throwable> throwables) {
            Throwable throwable = status.getException();
            if (throwable.getStackTrace().isEmpty()) {
                return true;
            }
            for (Throwable t : throwables) {
                if (!MultiStatusFilter.stackTraceMatches(throwable, t)) continue;
                return true;
            }
            throwables.add(throwable);
            return false;
        }

        private static boolean stackTraceMatches(Throwable throwable, Throwable t) {
            EList<StackTraceElement> stackTrace = throwable.getStackTrace();
            EList<StackTraceElement> stackTrace2 = t.getStackTrace();
            if (stackTrace.size() != stackTrace2.size()) {
                return false;
            }
            int i = 0;
            while (i < stackTrace.size()) {
                StackTraceElement ste2;
                StackTraceElement ste = (StackTraceElement)stackTrace.get(i);
                if (!MultiStatusFilter.classNameAndMethodNameEqual(ste, ste2 = (StackTraceElement)stackTrace2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static boolean classNameAndMethodNameEqual(StackTraceElement ste, StackTraceElement ste2) {
            return ste.getClassName().equals(ste2.getClassName()) && ste.getMethodName().equals(ste2.getMethodName());
        }
    }

    public static final class NotWhitelistedClassDetectorVisitor
    extends ModelSwitch<Object> {
        private List<Pattern> whitelist;
        private boolean detected = false;

        public NotWhitelistedClassDetectorVisitor(List<Pattern> whitelist) {
            this.whitelist = whitelist;
        }

        @Override
        public Object caseThrowable(Throwable throwable) {
            if (!Reports.isWhitelisted(throwable.getClassName(), this.whitelist)) {
                this.detected = true;
                return this.detected;
            }
            return null;
        }

        @Override
        public Object caseStackTraceElement(StackTraceElement element) {
            if (!Reports.isWhitelisted(element.getClassName(), this.whitelist)) {
                this.detected = true;
                return this.detected;
            }
            return null;
        }

        public boolean isDetected() {
            return this.detected;
        }
    }

    public static class PrettyPrintVisitor
    extends ModelSwitch<Object> {
        private static final int RIGHT_PADDING = 20;
        private StringBuilder reportStringBuilder = new StringBuilder();
        private StringBuilder statusStringBuilder = new StringBuilder();
        private StringBuilder bundlesStringBuilder = new StringBuilder();

        public PrettyPrintVisitor() {
            this.appendHeadline("BUNDLES", this.bundlesStringBuilder);
        }

        private void appendAttributes(EObject object, StringBuilder builder) {
            for (EAttribute attribute : object.eClass().getEAllAttributes()) {
                String format = "%-20s%s\n";
                Object value = Objects.firstNonNull((Object)object.eGet((EStructuralFeature)attribute), (Object)"");
                String line = String.format(format, attribute.getName(), value);
                builder.append(line);
            }
            builder.append("\n");
        }

        private void appendHeadline(String headline, StringBuilder builder) {
            if (builder.length() != 0) {
                builder.append("\n");
            }
            String line = String.valueOf(headline.replaceAll(".", "-")) + "\n";
            builder.append(line);
            builder.append(String.valueOf(headline) + "\n");
            builder.append(line);
        }

        @Override
        public Object caseErrorReport(ErrorReport report) {
            this.appendHeadline("REPORT", this.reportStringBuilder);
            this.appendAttributes(report, this.reportStringBuilder);
            return null;
        }

        @Override
        public Object caseStatus(Status status) {
            this.appendHeadline("STATUS", this.statusStringBuilder);
            this.appendAttributes(status, this.statusStringBuilder);
            Throwable exception = status.getException();
            if (exception != null) {
                this.statusStringBuilder.append("Exception:");
                this.append(exception, this.statusStringBuilder);
            }
            return null;
        }

        private void append(Throwable throwable, StringBuilder builder) {
            builder.append(String.format("%s: %s\n", throwable.getClassName(), throwable.getMessage()));
            for (StackTraceElement element : throwable.getStackTrace()) {
                builder.append(String.format("\t at %s.%s(%s:%s)\n", element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber()));
            }
            Throwable cause = throwable.getCause();
            if (cause != null) {
                this.statusStringBuilder.append("Caused by: ");
                this.append(cause, builder);
            }
        }

        @Override
        public Object caseBundle(Bundle bundle) {
            this.appendAttributes(bundle, this.bundlesStringBuilder);
            return null;
        }

        public String print() {
            return this.statusStringBuilder + "\n" + this.reportStringBuilder + this.bundlesStringBuilder;
        }
    }

    public static final class ThrowableFingerprintComputer
    extends ModelSwitch<Object> {
        private StringBuilder content = new StringBuilder();
        private List<Pattern> whitelist;
        private int maxframes;

        public ThrowableFingerprintComputer(List<Pattern> whitelist, int maxframes) {
            this.whitelist = whitelist;
            this.maxframes = maxframes;
        }

        @Override
        public Object caseStackTraceElement(StackTraceElement element) {
            if (this.maxframes < 0) {
                return Boolean.TRUE;
            }
            --this.maxframes;
            if (Reports.isWhitelisted(element.getClassName(), this.whitelist)) {
                this.content.append(element.getClassName()).append(element.getMethodName());
            }
            return null;
        }

        @Override
        public Object caseThrowable(Throwable throwable) {
            if (Reports.isWhitelisted(throwable.getClassName(), this.whitelist)) {
                this.content.append(throwable.getClassName());
            }
            return null;
        }

        public String hash() {
            return Hashing.murmur3_32().hashUnencodedChars((CharSequence)this.content.toString()).toString();
        }
    }
}

