/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.epp.internal.logging.aeri.ui.Events;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ProblemStatus;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NotificationAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NeedYourHelpNotification
extends Notification {
    private static Image IMG = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.epp.logging.aeri.ui", (String)"icons/obj16/database_error.png").createImage();
    private ProblemStatus state;
    private ErrorReport report;

    public NeedYourHelpNotification(ErrorReport report, ProblemStatus state, EventBus bus) {
        super("org.eclipse.epp.logging.aeri.notifications.event.needinfo", bus);
        this.state = state;
        this.report = report;
    }

    @Override
    public Image getNotificationImage() {
        return IMG;
    }

    @Override
    public String getTitle() {
        return "You hit a known issue in Eclipse.";
    }

    public String getLabel() {
        return String.format("'%s' appears to be hard to reproduce. Please help us fixing it by providing further details.", StringUtils.abbreviate((String)this.report.getStatus().getMessage(), (int)60));
    }

    public String getDescription() {
        return StringUtils.abbreviate((String)((String)this.state.getMessage().orNull()), (int)200);
    }

    @Override
    public List<NotificationAction> getActions() {
        ArrayList actions = Lists.newArrayList();
        NotificationAction a1 = new NotificationAction("View Details"){

            @Override
            public void execute() {
                NeedYourHelpNotification.this.closeWithEvent(new Events.NewReportShowDetailsRequest(NeedYourHelpNotification.this.report));
            }
        };
        actions.add(a1);
        if (this.state.hasBugId()) {
            NotificationAction a = new NotificationAction("Visit #" + this.state.getBugId()){

                @Override
                public void execute() {
                    NeedYourHelpNotification.this.closeWithEvent(new Events.OpenUrlInBrowserRequest((String)NeedYourHelpNotification.this.state.getBugUrl().get()));
                }
            };
            actions.add(a);
        }
        return actions;
    }

    @Override
    public void unhandled() {
        this.closeWithEvent(new Events.NeedInfoRequestdTimedOut());
    }
}

