/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NotificationAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.mylyn.commons.ui.compatibility.CommonColors;
import org.eclipse.mylyn.commons.workbench.AbstractWorkbenchNotificationPopup;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.commons.workbench.forms.ScalingHyperlink;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class NotificationPopup
extends AbstractWorkbenchNotificationPopup {
    private static final int MAX_LABEL_CHAR_LENGTH = 120;
    private static final int MAX_DESCRIPTION_CHAR_LENGTH = 500;
    private static final int MIN_HEIGHT = 100;
    private static final int MAX_WIDTH = 400;
    private static final int PADDING_EDGE = 5;
    private Notification notification;
    private List<ScalingHyperlink> links = Lists.newArrayList();
    private BlockPopupOnModalShellActivationListener blockPopupListener;

    private Label getTitleLabel(Control c) {
        if (c instanceof Label) {
            Label l = (Label)c;
            if (this.getPopupShellTitle().equals(l.getText())) {
                return l;
            }
        }
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cc = controlArray[n2];
                Label l = this.getTitleLabel(cc);
                if (l != null) {
                    return l;
                }
                ++n2;
            }
        }
        return null;
    }

    public void closeFade() {
        if (this.blockPopupListener.popupBlocked) {
            this.scheduleAutoClose();
            return;
        }
        if (this.blockPopupListener.popupReactivated) {
            this.blockPopupListener.popupReactivated = false;
            this.scheduleAutoClose();
            return;
        }
        super.closeFade();
    }

    public NotificationPopup(Display display) {
        super(display);
    }

    public NotificationPopup(Display display, int style) {
        super(display, style);
    }

    public Notification getNotification() {
        return this.notification;
    }

    public void setNotification(Notification notification) {
        this.notification = notification;
    }

    protected Image getPopupShellImage(int maximumHeight) {
        if (this.notification instanceof AbstractUiNotification) {
            return this.notification.getNotificationImage();
        }
        return super.getPopupShellImage(maximumHeight);
    }

    protected void createContentArea(Composite parent) {
        Composite contentComposite = new Composite(parent, 524288);
        GridLayout gridLayout = new GridLayout(2, false);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)contentComposite);
        contentComposite.setLayout((Layout)gridLayout);
        new Label(contentComposite, 524288);
        Label labelText = new Label(contentComposite, 524352);
        labelText.setForeground(CommonColors.TEXT_QUOTED);
        labelText.setText(StringUtils.abbreviate((String)this.notification.getLabel(), (int)120));
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)labelText);
        String description = this.notification.getDescription();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            Label descriptionText = new Label(contentComposite, 64);
            descriptionText.setText(StringUtils.abbreviate((String)description, (int)500));
            GridDataFactory.fillDefaults().span(2, -1).grab(true, false).align(4, 128).applyTo((Control)descriptionText);
        }
        if (this.notification instanceof Notification) {
            Notification executableNotification = this.notification;
            Composite linksComposite = new Composite(contentComposite, 655360);
            GridDataFactory.fillDefaults().span(2, -1).grab(true, false).align(0x1000008, 128).applyTo((Control)linksComposite);
            GridLayoutFactory.fillDefaults().numColumns(executableNotification.getActions().size()).applyTo(linksComposite);
            for (final NotificationAction action : executableNotification.getActions()) {
                ScalingHyperlink actionLink = new ScalingHyperlink(linksComposite, 655360);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)actionLink);
                Color linkColor = JFaceResources.getColorRegistry().get("HYPERLINK_COLOR");
                actionLink.setForeground(linkColor);
                actionLink.registerMouseTrackListener();
                actionLink.setText(action.getName());
                actionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        Shell windowShell;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null && (windowShell = window.getShell()) != null) {
                            if (windowShell.getMinimized()) {
                                windowShell.setMinimized(false);
                            }
                            windowShell.open();
                            windowShell.forceActive();
                        }
                        action.execute();
                    }
                });
                this.links.add(actionLink);
            }
        }
    }

    protected String getPopupShellTitle() {
        return this.notification.getTitle();
    }

    protected Color getTitleForeground() {
        return CommonFormUtil.getSharedColors().getColor("org.eclipse.ui.forms.TITLE");
    }

    protected void initializeBounds() {
        Rectangle clArea = this.getPrimaryClientArea();
        Shell shell = this.getShell();
        Point initialSize = shell.computeSize(400, -1);
        int height = Math.max(initialSize.y, 100);
        int width = Math.min(initialSize.x, 400);
        Point size = new Point(width, height);
        shell.setLocation(clArea.width + clArea.x - size.x - 5, clArea.height + clArea.y - size.y - 5);
        shell.setSize(size);
    }

    private Rectangle getPrimaryClientArea() {
        Monitor primaryMonitor = this.getShell().getDisplay().getPrimaryMonitor();
        return primaryMonitor != null ? primaryMonitor.getClientArea() : this.getShell().getDisplay().getClientArea();
    }

    public boolean close() {
        if (this.notification != null) {
            this.notification.close();
        }
        if (this.blockPopupListener != null) {
            PlatformUI.getWorkbench().getDisplay().removeFilter(26, (Listener)this.blockPopupListener);
        } else {
            Logs.log(LogMessages.ERROR_LISTENER_NULL);
        }
        return super.close();
    }

    public void create() {
        super.create();
        this.registerModalShellListener();
        Label titleLabel = this.getTitleLabel(this.getContents());
        if (titleLabel != null) {
            titleLabel.setCursor(this.getParentShell().getDisplay().getSystemCursor(0));
        }
    }

    private void registerModalShellListener() {
        this.blockPopupListener = new BlockPopupOnModalShellActivationListener();
        PlatformUI.getWorkbench().getDisplay().addFilter(26, (Listener)this.blockPopupListener);
    }

    private final class BlockPopupOnModalShellActivationListener
    implements Listener {
        private boolean popupBlocked = false;
        private boolean popupReactivated = false;
        private String title;
        private Label titleLabel;

        public BlockPopupOnModalShellActivationListener() {
            this.title = NotificationPopup.this.getPopupShellTitle();
            this.titleLabel = NotificationPopup.this.getTitleLabel(NotificationPopup.this.getContents());
            if (this.titleLabel != null) {
                this.title = this.titleLabel.getText();
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            Shell[] shellArray = workbench.getDisplay().getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (this.isVisibleAndModal(shell) && !this.popupBlocked) {
                    this.deactivate();
                }
                ++n2;
            }
        }

        public void handleEvent(Event event) {
            if (!this.isPopupOpen()) {
                return;
            }
            Widget w = event.widget;
            if (w instanceof Shell) {
                Shell shell = (Shell)w;
                if (this.isVisibleAndModal(shell)) {
                    if (!this.popupBlocked) {
                        this.deactivate();
                    }
                } else if (this.popupBlocked) {
                    this.popupReactivated = true;
                    this.activate();
                }
            }
        }

        private boolean isPopupOpen() {
            return NotificationPopup.this.getShell() != null && !NotificationPopup.this.getShell().isDisposed();
        }

        private boolean isVisibleAndModal(Shell shell) {
            int modal = 229376;
            return shell.isVisible() && (shell.getStyle() & modal) != 0;
        }

        private void deactivate() {
            this.popupBlocked = true;
            if (this.titleLabel != null) {
                this.titleLabel.setText("(Waiting for focus) " + this.title);
            }
            for (ScalingHyperlink link : NotificationPopup.this.links) {
                link.setEnabled(false);
            }
        }

        private void activate() {
            this.popupBlocked = false;
            if (this.titleLabel != null) {
                this.titleLabel.setText(this.title);
            }
            for (ScalingHyperlink link : NotificationPopup.this.links) {
                link.setEnabled(true);
            }
        }
    }
}

