/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.v2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.model.ServerResponse;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Json;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Proxies;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Responses;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerConfiguration;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerResponse05;

public class AeriServer {
    private Executor executor;
    private ServerConfiguration configuration;
    private File configurationFile;

    @VisibleForTesting
    protected static Response request(URI target, Executor executor) throws ClientProtocolException, IOException {
        int connectTimeout = (int)TimeUnit.SECONDS.toMillis(3L);
        int socketTimeout = (int)TimeUnit.SECONDS.toMillis(10L);
        Request request = Request.Get((URI)target).viaProxy((HttpHost)Proxies.getProxyHost(target).orNull()).connectTimeout(connectTimeout).staleConnectionCheck(true).socketTimeout(socketTimeout);
        return Proxies.proxyAuthentication(executor, target).execute(request);
    }

    public AeriServer(Executor executor, File configurationFile) {
        this.executor = executor;
        this.configurationFile = configurationFile;
    }

    public void refreshConfiguration(String serverUrl, IProgressMonitor monitor) throws HttpResponseException, UnknownHostException, Exception {
        Response response = AeriServer.request(AeriServer.newURI(serverUrl), this.executor);
        String content = Responses.getContentWithProgress(response, monitor);
        this.configuration = (ServerConfiguration)Json.deserialize(content, ServerConfiguration.class);
        this.configuration.setTimestamp(System.currentTimeMillis());
    }

    public void loadConfiguration() {
        this.configuration = (ServerConfiguration)Json.deserialize(this.configurationFile, ServerConfiguration.class);
    }

    public void saveConfiguration() {
        Json.serialize((Object)this.configuration, this.configurationFile);
    }

    public ServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public ServerResponse upload(ErrorReport report, IProgressMonitor monitor) throws IOException {
        String body = Reports.toJson(report, false);
        StringEntity stringEntity = new StringEntity(body, ContentType.APPLICATION_OCTET_STREAM.withCharset(Charsets.UTF_8));
        GzipCompressingEntity entity = new GzipCompressingEntity(Responses.decorateForProgressMonitoring((HttpEntity)stringEntity, monitor));
        String submitUrl = this.configuration.getSubmitUrl();
        URI target = AeriServer.newURI(submitUrl);
        Request request = Request.Post((URI)target).viaProxy((HttpHost)Proxies.getProxyHost(target).orNull()).body((HttpEntity)entity).connectTimeout(this.configuration.getConnectTimeoutMs()).staleConnectionCheck(true).socketTimeout(this.configuration.getSocketTimeoutMs());
        String response = Proxies.proxyAuthentication(this.executor, target).execute(request).returnContent().asString();
        ServerResponse05 response05 = (ServerResponse05)Json.deserialize(response, ServerResponse05.class);
        ServerResponse result = new ServerResponse();
        result.setReportTitle(StringUtils.abbreviate((String)report.getStatus().getMessage(), (int)80));
        result.setIncidentId((String)response05.getBugId().orNull());
        result.setIncidentUrl((String)response05.getBugUrl().orNull());
        result.setResolution(this.tryParse(response05));
        result.setCommitterMessage((String)response05.getInformation().orNull());
        return result;
    }

    private static URI newURI(String uri) throws IOException {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IOException("invalid server url", e);
        }
    }

    public int downloadDatabase(File destination, IProgressMonitor monitor) throws IOException {
        URI target = AeriServer.newURI(this.configuration.getProblemsUrl());
        Request request = Request.Get((URI)target).viaProxy((HttpHost)Proxies.getProxyHost(target).orNull()).connectTimeout(this.configuration.getConnectTimeoutMs()).staleConnectionCheck(true).socketTimeout(this.configuration.getSocketTimeoutMs());
        Response response = Proxies.proxyAuthentication(this.executor, target).execute(request);
        HttpResponse returnResponse = Responses.getResponseWithProgress(response, monitor);
        int statusCode = returnResponse.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            this.configuration.setProblemsZipLastDownloadTimestamp(System.currentTimeMillis());
            this.saveConfiguration();
            Throwable throwable = null;
            Object var9_10 = null;
            try (FileOutputStream out = new FileOutputStream(destination);){
                returnResponse.getEntity().writeTo((OutputStream)out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return statusCode;
    }

    private ServerResponse.ProblemResolution tryParse(ServerResponse05 state) {
        try {
            return ServerResponse.ProblemResolution.valueOf((String)state.getResolved().or((Object)ServerResponse.ProblemResolution.UNCONFIRMED.name()));
        }
        catch (Exception exception) {
            return ServerResponse.ProblemResolution.UNCONFIRMED;
        }
    }

    public boolean isProblemsDatabaseOutdated() {
        return System.currentTimeMillis() - this.configuration.getProblemsZipLastDownloadTimestamp() > this.configuration.getProblemsTtlMs();
    }

    public boolean isConfigurationOutdated() {
        return System.currentTimeMillis() - this.configuration.getTimestamp() > this.configuration.getTtlMs();
    }
}

