/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service.xml;

import java.util.Date;
import org.eclipse.epp.internal.mpc.core.service.xml.Unmarshaller;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class UnmarshalContentHandler {
    protected Unmarshaller unmarshaller;
    protected StringBuilder content;
    protected boolean capturingContent;
    protected Object parentModel;
    protected UnmarshalContentHandler parentHandler;

    public abstract void startElement(String var1, String var2, Attributes var3) throws SAXException;

    public abstract boolean endElement(String var1, String var2) throws SAXException;

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.capturingContent) {
            if (this.content == null) {
                this.content = new StringBuilder();
            }
            this.content.append(ch, start, length);
        }
    }

    protected Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    protected void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    protected Object getParentModel() {
        return this.parentModel;
    }

    protected void setParentModel(Object parentModel) {
        this.parentModel = parentModel;
    }

    protected UnmarshalContentHandler getParentHandler() {
        return this.parentHandler;
    }

    protected void setParentHandler(UnmarshalContentHandler parentHandler) {
        this.parentHandler = parentHandler;
    }

    protected String toUrlString(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string;
    }

    protected Date toDate(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        try {
            return new Date(Long.parseLong(string) * 1000L);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected Boolean toBoolean(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        if (!"1".equals(string) && !"true".equalsIgnoreCase(string)) {
            return false;
        }
        return true;
    }

    protected Integer toInteger(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected Integer toNatural(String string) {
        Integer intValue = this.toInteger(string);
        if (intValue != null && intValue < 0) {
            intValue = null;
        }
        return intValue;
    }

    protected Long toLong(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

