/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceProvider {
    private final File dir;
    private final Map<String, ResourceFuture> resources = new ConcurrentHashMap<String, ResourceFuture>();

    public ResourceProvider() throws IOException {
        this.dir = File.createTempFile(ResourceProvider.class.getSimpleName(), ".tmp");
        this.dir.delete();
        if (!this.dir.mkdirs() || !this.dir.isDirectory()) {
            throw new IOException(NLS.bind((String)Messages.ResourceProvider_FailedCreatingTempDir, (Object)this.dir.getAbsolutePath()));
        }
    }

    public URL getLocalResource(String resourceName) {
        ResourceFuture resource = this.getResource(resourceName);
        try {
            return resource == null ? null : (resource.isCancelled() || !resource.isDone() ? null : (URL)resource.get());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceFuture getResource(String resourceName) {
        Map<String, ResourceFuture> map = this.resources;
        synchronized (map) {
            return this.resources.get(resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsResource(String resourceName) {
        Map<String, ResourceFuture> map = this.resources;
        synchronized (map) {
            return this.resources.containsKey(resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceFuture registerResource(String resourceName) throws IOException {
        ResourceFuture resourceFuture;
        Map<String, ResourceFuture> map = this.resources;
        synchronized (map) {
            resourceFuture = this.resources.get(resourceName);
            if (resourceFuture == null) {
                String filenameHint = resourceName;
                if (filenameHint.lastIndexOf(47) != -1) {
                    filenameHint = filenameHint.substring(filenameHint.lastIndexOf(47) + 1);
                }
                if ((filenameHint = filenameHint.replaceAll("[^a-zA-Z0-9\\.]", "_")).length() > 32) {
                    String hash = Integer.toHexString(filenameHint.hashCode());
                    filenameHint = String.valueOf(filenameHint.substring(0, 6)) + "_" + hash + "_" + filenameHint.substring(filenameHint.length() - (32 - hash.length() - 1 - 6 - 1));
                }
                File outputFile = this.createTempFile(filenameHint);
                outputFile.deleteOnExit();
                resourceFuture = new ResourceFuture(outputFile);
                this.resources.put(resourceName, resourceFuture);
            }
        }
        return resourceFuture;
    }

    private File createTempFile(String filenameHint) throws IOException {
        int i = 0;
        while (i < 5) {
            try {
                if (!this.dir.isDirectory() && !this.dir.mkdirs()) {
                    throw new IOException(NLS.bind((String)Messages.ResourceProvider_FailedCreatingTempDir, (Object)this.dir.getAbsolutePath()));
                }
                File outputFile = File.createTempFile("res_", filenameHint, this.dir);
                return outputFile;
            }
            catch (IOException iOException) {
                ++i;
            }
        }
        File outputFile = File.createTempFile("res_", filenameHint, this.dir);
        return outputFile;
    }

    public ResourceFuture retrieveResource(String requestSource, String resourceUrl) throws IOException, URISyntaxException {
        URI resourceUri = URLUtil.toURI((String)resourceUrl);
        return this.retrieveResource(requestSource, resourceUrl, resourceUri);
    }

    public ResourceFuture retrieveResource(String requestSource, URI resourceUrl) throws IOException {
        return this.retrieveResource(requestSource, resourceUrl.toString(), resourceUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceFuture retrieveResource(final String requestSource, String resourceName, final URI resourceUrl) throws IOException {
        ResourceFuture resourceFuture;
        Map<String, ResourceFuture> map = this.resources;
        synchronized (map) {
            resourceFuture = this.resources.get(resourceName);
            if (resourceFuture == null) {
                ResourceFuture finalResourceFuture;
                resourceFuture = finalResourceFuture = this.registerResource(resourceName);
                new Job(Messages.ResourceProvider_retrievingResource){
                    {
                        super($anonymous0);
                        this.setPriority(10);
                        this.setUser(false);
                        this.setSystem(true);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            InputStream in = TransportFactory.createTransport().stream(resourceUrl, monitor);
                            finalResourceFuture.retrieve(in);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        catch (IOException e) {
                            if (!(e.getCause() instanceof OperationCanceledException)) {
                                MarketplaceClientUi.log(2, Messages.ResourceProvider_downloadError, requestSource, resourceUrl, e);
                            }
                        }
                        catch (CoreException e) {
                            MarketplaceClientUi.log(2, Messages.ResourceProvider_downloadError, new Object[]{requestSource, resourceUrl, e});
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
        return resourceFuture;
    }

    public void dispose() {
        if (this.dir != null && this.dir.exists()) {
            File[] files = this.dir.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    file.delete();
                    ++n2;
                }
            }
            this.dir.delete();
        }
        this.resources.clear();
    }

    public <T> void provideResource(final ResourceReceiver<T> receiver, final String resourcePath, T fallbackResource) {
        final ResourceFuture resource = this.getResource(resourcePath);
        if (resource != null) {
            if (resource.isDone()) {
                this.setResource(receiver, resourcePath, resource);
                return;
            }
            if (fallbackResource != null) {
                receiver.setResource(fallbackResource);
            }
            new Job(Messages.ResourceProvider_waitingForDownload){
                {
                    super($anonymous0);
                    this.setPriority(10);
                    this.setUser(false);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    return ResourceProvider.this.setResource(receiver, resourcePath, resource);
                }
            }.schedule();
        } else if (fallbackResource != null) {
            receiver.setResource(fallbackResource);
        }
    }

    private <T> IStatus setResource(ResourceReceiver<T> receiver, String resourcePath, ResourceFuture resource) {
        try {
            URL resourceUrl = resource.get();
            if (resourceUrl != null) {
                T processedResource = receiver.processResource(resourceUrl);
                receiver.setResource(processedResource);
            }
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        catch (ExecutionException executionException) {}
        return Status.OK_STATUS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ResourceFuture
    implements Future<URL> {
        private InputStream input;
        private final FutureTask<URL> delegate;

        ResourceFuture(final File outputFile) {
            this.delegate = new FutureTask<URL>(new Callable<URL>(){

                @Override
                public URL call() throws Exception {
                    URL outputURL;
                    if (ResourceFuture.this.input == null) {
                        throw new IllegalStateException();
                    }
                    try {
                        outputURL = outputFile.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        MarketplaceClientUi.error(e);
                        return null;
                    }
                    BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));
                    boolean success = false;
                    try {
                        int i;
                        BufferedInputStream buffered = new BufferedInputStream(ResourceFuture.this.input);
                        while ((i = ((InputStream)buffered).read()) != -1) {
                            output.write(i);
                        }
                        success = true;
                    }
                    finally {
                        output.close();
                        if (!success || !outputFile.exists()) {
                            outputFile.delete();
                            outputURL = null;
                        }
                    }
                    return outputURL;
                }
            });
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public URL get() throws InterruptedException, ExecutionException {
            return this.delegate.get();
        }

        @Override
        public URL get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.get(timeout, unit);
        }

        FutureTask<URL> getDelegate() {
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL retrieve(InputStream stream) throws IOException {
            ResourceFuture resourceFuture;
            URL uRL;
            ResourceFuture resourceFuture2 = this;
            synchronized (resourceFuture2) {
                if (this.isDone() || this.input != null) {
                    return this.getURL();
                }
                this.input = stream;
            }
            try {
                this.delegate.run();
                uRL = this.getURL();
                resourceFuture = this;
            }
            catch (Throwable throwable) {
                ResourceFuture resourceFuture3 = this;
                synchronized (resourceFuture3) {
                    this.input = null;
                }
                throw throwable;
            }
            synchronized (resourceFuture) {
                this.input = null;
            }
            return uRL;
        }

        public URL getURL() throws IOException {
            try {
                return this.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)cause;
                    throw runtimeException;
                }
                if (cause instanceof IOException) {
                    IOException ioException = (IOException)cause;
                    throw ioException;
                }
                IOException ioException = new IOException(cause.getMessage());
                ioException.initCause(cause);
                throw ioException;
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }

        public URL getLocalURL() {
            if (this.isDone() && !this.isCancelled()) {
                try {
                    return this.getURL();
                }
                catch (Exception exception) {}
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResourceReceiver<T> {
        public T processResource(URL var1);

        public void setResource(T var1);
    }
}

