/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.cloudio.internal.ui.application;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import org.eclipse.gef4.cloudio.ui.TagCloud;
import org.eclipse.gef4.cloudio.ui.Word;
import org.eclipse.gef4.cloudio.ui.layout.DefaultLayouter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AboutDialog
extends Dialog {
    private static final int RE_LAYOUT = 2;
    private TagCloud tc;

    public AboutDialog(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(false);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.tc = new TagCloud(parent, 0){

            public Rectangle getClientArea() {
                return new Rectangle(0, 0, 400, 330);
            }
        };
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 330;
        data.widthHint = 400;
        this.tc.setLayoutData(data);
        this.tc.setMaxFontSize(50);
        this.tc.setMinFontSize(15);
        this.tc.setLayouter(new DefaultLayouter(5, 0));
        ArrayList<Word> values = new ArrayList<Word>();
        String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Color[] colors = new Color[]{Display.getDefault().getSystemColor(14), Display.getDefault().getSystemColor(6), Display.getDefault().getSystemColor(12), Display.getDefault().getSystemColor(8), Display.getDefault().getSystemColor(15)};
        Word w = this.getWord("Cloudio", fontNames, colors);
        w.weight = 0.95;
        w.angle = -35.0f;
        w.setColor(Display.getDefault().getSystemColor(1));
        values.add(w);
        w = this.getWord("Inspired by Wordle", fontNames, colors);
        w.setColor(Display.getDefault().getSystemColor(1));
        w.angle = (float)(Math.random() * 90.0);
        if (Math.random() < 0.5) {
            w.angle = -w.angle;
        }
        w.weight = 0.2;
        if (Math.random() < 0.5) {
            w.angle = -w.angle;
        }
        values.add(w);
        w = this.getWord("Used by " + System.getProperty("user.name"), fontNames, colors);
        w.setColor(Display.getDefault().getSystemColor(1));
        w.weight = 0.2;
        values.add(w);
        int i = 0;
        while (i < 20) {
            w = this.getWord("Cloudio", fontNames, colors);
            values.add(w);
            w = this.getWord("Tag Cloud", fontNames, colors);
            values.add(w);
            ++i;
        }
        this.tc.setWords(values, null);
        Label l = new Label(parent, 0);
        l.setText("Written by Stephan Schwiebert, 2011");
        return this.tc;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 2, "Do the inevitable...", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            this.tc.layoutCloud(null, false);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private Word getWord(String string, String[] fontNames, Color[] colors) {
        Word w = new Word(string);
        w.setColor(colors[(int)(Math.random() * (double)colors.length - 1.0)]);
        w.weight = Math.random() / 2.0;
        w.setFontData(this.getShell().getFont().getFontData());
        w.angle = (float)(Math.random() * 20.0);
        if (Math.random() < 0.5) {
            w.angle = -w.angle;
        }
        String name = fontNames[(int)(Math.random() * (double)(fontNames.length - 1))];
        FontData[] fontDataArray = w.getFontData();
        int n = fontDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setName(name);
            ++n2;
        }
        return w;
    }

    public boolean close() {
        this.tc.dispose();
        return super.close();
    }
}

