/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.inject;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.multibindings.MapBinderBinding;
import com.google.inject.multibindings.MultibinderBinding;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.inject.AdapterMap;

public class AdapterMapInjector
implements MembersInjector<IAdaptable> {
    private final List<Object> deferredInstances = new ArrayList<Object>();
    private Injector injector;
    private final Method method;
    private final AdapterMap methodAnnotation;

    public AdapterMapInjector(Method method, AdapterMap methodAnnotation) {
        this.method = method;
        this.methodAnnotation = methodAnnotation;
    }

    protected SortedMap<Key<?>, Binding<?>> getPolymorphicAdapterMapBindings(Class<?> adaptableType, Method method, AdapterMap methodAnnotation) {
        Map allBindings = this.injector.getAllBindings();
        TreeMap polymorphicBindings = new TreeMap(new Comparator<Key<?>>(){

            @Override
            public int compare(Key<?> o1, Key<?> o2) {
                if (!AdapterMap.class.equals((Object)o1.getAnnotationType()) || !AdapterMap.class.equals((Object)o2.getAnnotationType())) {
                    throw new IllegalArgumentException("Can only compare keys with AdapterMap annotations");
                }
                AdapterMap a1 = (AdapterMap)o1.getAnnotation();
                AdapterMap a2 = (AdapterMap)o2.getAnnotation();
                if (a1.adaptableType().equals(a2.adaptableType())) {
                    return 0;
                }
                if (a1.adaptableType().isAssignableFrom(a2.adaptableType())) {
                    return -1;
                }
                return 1;
            }
        });
        for (Key key : allBindings.keySet()) {
            if (key.getAnnotationType() == null || !AdapterMap.class.equals((Object)key.getAnnotationType())) continue;
            AdapterMap keyAnnotation = (AdapterMap)key.getAnnotation();
            if (methodAnnotation.adaptableType().equals(keyAnnotation.adaptableType()) || !keyAnnotation.adaptableType().isAssignableFrom(adaptableType)) continue;
            polymorphicBindings.put(key, (Binding)allBindings.get(key));
        }
        return polymorphicBindings;
    }

    protected void injectAdapters(Object adaptable) {
        SortedMap<Key<?>, Binding<?>> polymorphicBindings = this.getPolymorphicAdapterMapBindings(adaptable.getClass(), this.method, this.methodAnnotation);
        for (Map.Entry<Key<?>, Binding<?>> entry : polymorphicBindings.entrySet()) {
            try {
                Map target = (Map)entry.getValue().acceptTargetVisitor((BindingTargetVisitor)new AdapterBindingsTargetVisitor());
                if (target == null || target.isEmpty()) continue;
                this.method.invoke(adaptable, target);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void injectMembers(IAdaptable instance) {
        if (this.injector == null) {
            this.deferredInstances.add(instance);
        } else {
            this.injectAdapters(instance);
        }
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
        for (Object instance : this.deferredInstances) {
            this.injectAdapters(instance);
        }
        this.deferredInstances.clear();
    }

    private class AdapterBindingsTargetVisitor
    implements MultibindingsTargetVisitor<Object, Map<AdapterKey<?>, Object>> {
        private AdapterBindingsTargetVisitor() {
        }

        public Map<AdapterKey<?>, Object> visit(ConstructorBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ConvertedConstantBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ExposedBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(InstanceBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(LinkedKeyBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(MapBinderBinding<? extends Object> mapbinding) {
            HashMap bindings = new HashMap();
            for (Map.Entry entry : mapbinding.getEntries()) {
                AdapterKey key = (AdapterKey)entry.getKey();
                Object value = ((Binding)entry.getValue()).getProvider().get();
                bindings.put(key, value);
            }
            return bindings;
        }

        public Map<AdapterKey<?>, Object> visit(MultibinderBinding<? extends Object> multibinding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ProviderBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ProviderInstanceBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ProviderKeyBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(UntargettedBinding<? extends Object> binding) {
            return null;
        }
    }
}

