/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.notify;

import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.gef4.common.notify.IListObserver;

public class ObservableList<T>
extends ForwardingList<T> {
    private List<IListObserver<T>> observers = new ArrayList<IListObserver<T>>();
    private List<T> backingList = new ArrayList<T>();

    public void add(int index, T element) {
        List<T> old = this.getBackingListCopy();
        super.add(index, element);
        this.notifyChanged(old);
    }

    public boolean add(T element) {
        List<T> old = this.getBackingListCopy();
        boolean changed = super.add(element);
        if (changed) {
            this.notifyChanged(old);
        }
        return changed;
    }

    public boolean addAll(Collection<? extends T> collection) {
        List<T> old = this.getBackingListCopy();
        if (super.addAll(collection)) {
            this.notifyChanged(old);
            return true;
        }
        return false;
    }

    public boolean addAll(int index, Collection<? extends T> elements) {
        List<T> old = this.getBackingListCopy();
        if (super.addAll(index, elements)) {
            this.notifyChanged(old);
            return true;
        }
        return false;
    }

    public void addListObserver(IListObserver<T> listObserver) {
        this.observers.add(listObserver);
    }

    public void clear() {
        List<T> old = this.getBackingListCopy();
        if (!this.isEmpty()) {
            super.clear();
            this.notifyChanged(old);
        }
    }

    protected List<T> delegate() {
        return this.backingList;
    }

    protected List<T> getBackingListCopy() {
        return new ArrayList<T>(this.backingList);
    }

    protected void notifyChanged(List<T> old) {
        for (IListObserver<T> observer : this.observers) {
            observer.afterChange(this, old);
        }
    }

    public T remove(int index) {
        List<T> old = this.getBackingListCopy();
        Object removed = super.remove(index);
        this.notifyChanged(old);
        return (T)removed;
    }

    public boolean remove(Object object) {
        List<T> old = this.getBackingListCopy();
        boolean changed = super.remove(object);
        if (changed) {
            this.notifyChanged(old);
        }
        return changed;
    }

    public boolean removeAll(Collection<?> collection) {
        List<T> old = this.getBackingListCopy();
        if (super.removeAll(collection)) {
            this.notifyChanged(old);
            return true;
        }
        return false;
    }

    public void removeListObserver(IListObserver<T> listObserver) {
        this.observers.remove(listObserver);
    }

    public boolean retainAll(Collection<?> collection) {
        List<T> old = this.getBackingListCopy();
        if (super.retainAll(collection)) {
            this.notifyChanged(old);
            return true;
        }
        return false;
    }

    public T set(int index, T element) {
        List<T> old = this.getBackingListCopy();
        Object previous = super.set(index, element);
        if (previous != element) {
            this.notifyChanged(old);
        }
        return (T)previous;
    }
}

