/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.properties;

import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef4.common.properties.IPropertyStore;

public class PropertyStoreSupport {
    private Map<String, Object> properties = new HashMap<String, Object>();
    private PropertyChangeSupport pcs;

    public PropertyStoreSupport(IPropertyStore source, PropertyChangeSupport pcs) {
        if (source == null) {
            throw new IllegalArgumentException("source may not be null.");
        }
        if (pcs == null) {
            throw new IllegalArgumentException("pcs may not be null.");
        }
        this.pcs = pcs;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        Object oldValue = this.properties.get(name);
        this.properties.put(name, value);
        if (!(oldValue == value || oldValue != null && oldValue.equals(value))) {
            this.pcs.firePropertyChange(name, oldValue, value);
        }
    }
}

