/*******************************************************************************
 * Copyright (c) 2013, 2014 itemis AG and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Matthias Wienand (itemis AG) - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.gef4.fx.nodes;

import javafx.scene.Node;

import org.eclipse.gef4.geometry.planar.Point;

/**
 * An {@link IFXDecoration} can be used to add a visual (an arrow, for example)
 * to the start or end point of an {@link FXConnection}.
 *
 * @author mwienand
 *
 */
public interface IFXDecoration {

	/**
	 * Returns the end point of this decoration in the local coordinate space of
	 * its {@link #getVisual() visual}.
	 *
	 * @return the (local) end point of this decoration
	 */
	public Point getLocalEndPoint();

	/**
	 * Returns the start point of this decoration in the local coordinate space
	 * of its {@link #getVisual() visual}.
	 *
	 * @return the (local) start point of this decoration
	 */
	public Point getLocalStartPoint();

	/**
	 * Returns the decoration's visual, for example, an arrow shape.
	 *
	 * @return the decoration's visual
	 */
	public Node getVisual();

}
