/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.anchors;

import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef4.fx.anchors.AbstractFXAnchor;
import org.eclipse.gef4.fx.anchors.AnchorKey;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.Point;

public class FXStaticAnchor
extends AbstractFXAnchor {
    private Point referencePosition;

    public FXStaticAnchor(Node anchorage, Point referencePositionInAnchorageLocal) {
        super(anchorage);
        this.referencePosition = referencePositionInAnchorageLocal;
    }

    public FXStaticAnchor(Point referencePositionInScene) {
        super(null);
        this.referencePosition = referencePositionInScene;
    }

    @Override
    protected Point computePosition(AnchorKey key) {
        Node anchored = key.getAnchored();
        Node anchorage = this.getAnchorage();
        Point positionInScene = anchorage == null ? this.referencePosition : JavaFX2Geometry.toPoint((Point2D)anchorage.localToScene(this.referencePosition.x, this.referencePosition.y));
        Point positionInAnchoredLocal = JavaFX2Geometry.toPoint((Point2D)anchored.sceneToLocal(positionInScene.x, positionInScene.y));
        return positionInAnchoredLocal;
    }

    public String toString() {
        return "FXStaticAnchor[referencePosition = " + this.referencePosition + "]";
    }
}

