/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Scale;

public class FXGridLayer
extends Pane {
    private final GridCanvas gridCanvas;
    private final SimpleObjectProperty<Scale> gridScaleProperty = new SimpleObjectProperty((Object)new Scale());
    private final DoubleProperty gridCellHeightProperty = new SimpleDoubleProperty(10.0);
    private final DoubleProperty gridCellWidthProperty = new SimpleDoubleProperty(10.0);

    public FXGridLayer() {
        this.gridCanvas = new GridCanvas();
        this.gridCanvas.setManaged(false);
        this.getChildren().add((Object)this.gridCanvas);
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.gridCanvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.gridCanvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setPickOnBounds(false);
        this.setMouseTransparent(true);
        this.gridScaleProperty.addListener((ChangeListener)new ChangeListener<Scale>(){

            public void changed(ObservableValue<? extends Scale> observable, Scale oldValue, Scale newValue) {
                FXGridLayer.this.gridCanvas.repaintGrid();
            }
        });
        this.gridCellWidthProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                FXGridLayer.this.gridCanvas.repaintGrid();
            }
        });
        this.gridCellHeightProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                FXGridLayer.this.gridCanvas.repaintGrid();
            }
        });
        this.layoutXProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                FXGridLayer.this.gridCanvas.repaintGrid();
            }
        });
        this.layoutYProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                FXGridLayer.this.gridCanvas.repaintGrid();
            }
        });
    }

    public void bindMinSizeToBounds(final ReadOnlyObjectProperty<Bounds> minSizeProperty) {
        this.minWidthProperty().bind((ObservableValue)new DoubleBinding(){
            {
                super.bind(new Observable[]{readOnlyObjectProperty, ((Scale)FXGridLayer.this.gridScaleProperty.get()).xProperty()});
            }

            protected double computeValue() {
                if (minSizeProperty.get() == null) {
                    return 0.0;
                }
                return ((Bounds)minSizeProperty.get()).getWidth();
            }
        });
        this.minHeightProperty().bind((ObservableValue)new DoubleBinding(){
            {
                super.bind(new Observable[]{readOnlyObjectProperty, ((Scale)FXGridLayer.this.gridScaleProperty.get()).yProperty()});
            }

            protected double computeValue() {
                if (minSizeProperty.get() == null) {
                    return 0.0;
                }
                return ((Bounds)minSizeProperty.get()).getHeight();
            }
        });
    }

    public void bindPrefSizeToUnionedBounds(final ReadOnlyObjectProperty<Bounds> ... boundsProperties) {
        this.layoutXProperty().bind((ObservableValue)new DoubleBinding(){
            {
                super.bind((Observable[])readOnlyObjectPropertyArray);
            }

            protected double computeValue() {
                double minX = 0.0;
                ReadOnlyObjectProperty[] readOnlyObjectPropertyArray = boundsProperties;
                int n = boundsProperties.length;
                int n2 = 0;
                while (n2 < n) {
                    ReadOnlyObjectProperty b = readOnlyObjectPropertyArray[n2];
                    minX = Math.min(minX, ((Bounds)b.get()).getMinX());
                    ++n2;
                }
                return minX;
            }
        });
        this.layoutYProperty().bind((ObservableValue)new DoubleBinding(){
            {
                super.bind((Observable[])readOnlyObjectPropertyArray);
            }

            protected double computeValue() {
                double minY = 0.0;
                ReadOnlyObjectProperty[] readOnlyObjectPropertyArray = boundsProperties;
                int n = boundsProperties.length;
                int n2 = 0;
                while (n2 < n) {
                    ReadOnlyObjectProperty b = readOnlyObjectPropertyArray[n2];
                    minY = Math.min(minY, ((Bounds)b.get()).getMinY());
                    ++n2;
                }
                return minY;
            }
        });
        this.prefWidthProperty().bind((ObservableValue)new DoubleBinding(){
            {
                super.bind((Observable[])readOnlyObjectPropertyArray);
            }

            protected double computeValue() {
                double minX = 0.0;
                double maxX = 0.0;
                ReadOnlyObjectProperty[] readOnlyObjectPropertyArray = boundsProperties;
                int n = boundsProperties.length;
                int n2 = 0;
                while (n2 < n) {
                    ReadOnlyObjectProperty b = readOnlyObjectPropertyArray[n2];
                    Bounds bounds = (Bounds)b.get();
                    minX = Math.min(minX, bounds.getMinX());
                    maxX = Math.max(maxX, bounds.getMaxX());
                    ++n2;
                }
                return maxX - minX;
            }
        });
        this.prefHeightProperty().bind((ObservableValue)new DoubleBinding(){
            {
                super.bind((Observable[])readOnlyObjectPropertyArray);
            }

            protected double computeValue() {
                double minY = 0.0;
                double maxY = 0.0;
                ReadOnlyObjectProperty[] readOnlyObjectPropertyArray = boundsProperties;
                int n = boundsProperties.length;
                int n2 = 0;
                while (n2 < n) {
                    ReadOnlyObjectProperty b = readOnlyObjectPropertyArray[n2];
                    Bounds bounds = (Bounds)b.get();
                    minY = Math.min(minY, bounds.getMinY());
                    maxY = Math.max(maxY, bounds.getMaxY());
                    ++n2;
                }
                return maxY - minY;
            }
        });
    }

    public ObjectProperty<Scale> gridScaleProperty() {
        return this.gridScaleProperty;
    }

    public void setGridHeight(double height) {
        this.gridCellHeightProperty.set(height);
    }

    public void setGridWidth(double width) {
        this.gridCellWidthProperty.set(width);
    }

    private class GridCanvas
    extends Canvas {
        private static final int GRID_THRESHOLD = 5000000;

        public GridCanvas() {
            this.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    GridCanvas.this.repaintGrid();
                }
            });
            this.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    GridCanvas.this.repaintGrid();
                }
            });
        }

        public boolean isResizable() {
            return true;
        }

        public double prefHeight(double width) {
            return this.getHeight();
        }

        public double prefWidth(double height) {
            return this.getWidth();
        }

        public void repaintGrid() {
            double width = this.getWidth();
            double height = this.getHeight();
            GraphicsContext gc = this.getGraphicsContext2D();
            gc.setFill((Paint)Color.WHITE);
            gc.fillRect(0.0, 0.0, width, height);
            Scale scale = (Scale)FXGridLayer.this.gridScaleProperty.get();
            if (width / scale.getX() * (height / scale.getY()) > 5000000.0) {
                return;
            }
            gc.setFill((Paint)Color.GREY);
            double scaledGridCellWidth = FXGridLayer.this.gridCellWidthProperty.get() * scale.getX();
            double scaledGridCellHeight = FXGridLayer.this.gridCellHeightProperty.get() * scale.getY();
            double x = -this.getParent().getLayoutX() % scaledGridCellWidth;
            while (x < width) {
                double y = -this.getParent().getLayoutY() % scaledGridCellHeight;
                while (y < height) {
                    gc.fillRect(Math.floor(x) - 0.5 * scale.getX(), Math.floor(y) - 0.5 * scale.getY(), scale.getX(), scale.getY());
                    y += scaledGridCellHeight;
                }
                x += scaledGridCellWidth;
            }
        }
    }
}

