/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Robot;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.geom.NoninvertibleTransformException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.transform.Transform;
import org.eclipse.gef4.fx.FxBundle;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;

public class FXUtils {
    private static final String JAVA_AWT_HEADLESS_PROPERTY = "java.awt.headless";

    public static void forceCursorUpdate(Scene scene) {
        try {
            Field mouseHandlerField = scene.getClass().getDeclaredField("mouseHandler");
            mouseHandlerField.setAccessible(true);
            Object mouseHandler = mouseHandlerField.get(scene);
            Class<?> mouseHandlerClass = Class.forName("javafx.scene.Scene$MouseHandler");
            Method updateCursorMethod = mouseHandlerClass.getDeclaredMethod("updateCursor", Cursor.class);
            updateCursorMethod.setAccessible(true);
            updateCursorMethod.invoke(mouseHandler, scene.getCursor());
            Method updateCursorFrameMethod = mouseHandlerClass.getDeclaredMethod("updateCursorFrame", new Class[0]);
            updateCursorFrameMethod.setAccessible(true);
            updateCursorFrameMethod.invoke(mouseHandler, new Object[0]);
        }
        catch (Exception x) {
            throw new IllegalStateException(x);
        }
    }

    public static AffineTransform getLocalToSceneTx(Node node) {
        AffineTransform tx = JavaFX2Geometry.toAffineTransform((Transform)node.getLocalToParentTransform());
        Node tmp = node;
        while (tmp.getParent() != null) {
            tmp = tmp.getParent();
            tx = JavaFX2Geometry.toAffineTransform((Transform)tmp.getLocalToParentTransform()).concatenate(tx);
        }
        return tx;
    }

    public static List<Node> getNodesAt(Node root, double sceneX, double sceneY) {
        ArrayList<Node> picked = new ArrayList<Node>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(root);
        while (!nodes.isEmpty()) {
            Node current = (Node)nodes.remove(0);
            Point2D pLocal = current.sceneToLocal(sceneX, sceneY);
            if (current.isMouseTransparent() || !current.getBoundsInLocal().contains(pLocal)) continue;
            if (current.contains(pLocal)) {
                picked.add(0, current);
            }
            if (!(current instanceof Parent)) continue;
            nodes.addAll(0, (Collection<Node>)((Parent)current).getChildrenUnmodifiable());
        }
        return picked;
    }

    public static Point getPointerLocation() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Mac OS X") && FxBundle.getContext() == null) {
            Robot robot = Application.GetApplication().createRobot();
            return new Point((double)robot.getMouseX(), (double)robot.getMouseY());
        }
        String awtHeadlessPropertyValue = System.getProperty(JAVA_AWT_HEADLESS_PROPERTY);
        if (awtHeadlessPropertyValue != null && awtHeadlessPropertyValue != Boolean.FALSE.toString()) {
            System.setProperty(JAVA_AWT_HEADLESS_PROPERTY, Boolean.FALSE.toString());
        }
        PointerInfo pi = MouseInfo.getPointerInfo();
        java.awt.Point mp = pi.getLocation();
        if (awtHeadlessPropertyValue != null) {
            System.setProperty(JAVA_AWT_HEADLESS_PROPERTY, awtHeadlessPropertyValue);
        }
        return new Point((double)mp.x, (double)mp.y);
    }

    public static AffineTransform getSceneToLocalTx(Node node) {
        try {
            return FXUtils.getLocalToSceneTx(node).invert();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static IGeometry localToParent(Node n, IGeometry g) {
        AffineTransform localToParentTx = JavaFX2Geometry.toAffineTransform((Transform)n.getLocalToParentTransform());
        return g.getTransformed(localToParentTx);
    }

    public static IGeometry localToScene(Node n, IGeometry g) {
        AffineTransform localToSceneTx = FXUtils.getLocalToSceneTx(n);
        return g.getTransformed(localToSceneTx);
    }

    public static Point localToScene(Node n, Point p) {
        AffineTransform localToSceneTx = FXUtils.getLocalToSceneTx(n);
        return localToSceneTx.getTransformed(p);
    }

    public static IGeometry parentToLocal(Node n, IGeometry g) {
        AffineTransform localToParentTx = JavaFX2Geometry.toAffineTransform((Transform)n.getLocalToParentTransform());
        AffineTransform parentToLocalTx = null;
        try {
            parentToLocalTx = localToParentTx.getCopy().invert();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalStateException(e);
        }
        return g.getTransformed(parentToLocalTx);
    }

    public static IGeometry sceneToLocal(Node n, IGeometry g) {
        AffineTransform sceneToLocalTx = FXUtils.getSceneToLocalTx(n);
        return g.getTransformed(sceneToLocalTx);
    }
}

