/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import javafx.animation.FadeTransition;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.transform.Affine;
import javafx.util.Duration;

public class ScrollPaneEx
extends Region {
    private Group scrollbarGroup;
    private ScrollBar horizontalScrollBar;
    private ScrollBar verticalScrollBar;
    private Pane scrolledPane;
    private Group contentGroup;
    private Affine viewportTransform = new Affine();
    private double[] currentScrollableBounds = new double[]{0.0, 0.0, 0.0, 0.0};
    private ChangeListener<Number> widthChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldWidth, Number newWidth) {
            ScrollPaneEx.this.updateScrollbars();
        }
    };
    private ChangeListener<Number> heightChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldHeight, Number newHeight) {
            ScrollPaneEx.this.updateScrollbars();
        }
    };
    private ChangeListener<Bounds> canvasBoundsInLocalChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldBounds, Bounds newBounds) {
            ScrollPaneEx.this.updateScrollbars();
        }
    };
    private ChangeListener<? super Bounds> contentBoundsInParentChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            ScrollPaneEx.this.updateScrollbars();
        }
    };
    private ObjectBinding<Bounds> contentBoundsBinding;
    private ObjectBinding<Bounds> scrollableBoundsBinding;

    public ScrollPaneEx() {
        this.getChildren().addAll((Object[])new Node[]{this.getScrolledPane(), this.getScrollbarGroup()});
        this.getScrolledPane().boundsInLocalProperty().addListener(this.canvasBoundsInLocalChangeListener);
        this.widthProperty().addListener(this.widthChangeListener);
        this.heightProperty().addListener(this.heightChangeListener);
        this.contentBoundsBinding = new ObjectBinding<Bounds>(){
            {
                this.bind(new Observable[]{ScrollPaneEx.this.contentGroup.boundsInParentProperty()});
            }

            protected Bounds computeValue() {
                double[] bb = ScrollPaneEx.this.computeContentBoundsInLocal();
                return new BoundingBox(bb[0], bb[1], bb[2] - bb[0], bb[3] - bb[1]);
            }
        };
        this.scrollableBoundsBinding = new ObjectBinding<Bounds>(){
            {
                this.bind(new Observable[]{ScrollPaneEx.this.contentGroup.boundsInParentProperty(), ScrollPaneEx.this.widthProperty(), ScrollPaneEx.this.heightProperty()});
            }

            protected Bounds computeValue() {
                double[] bb = ScrollPaneEx.this.computeScrollableBoundsInLocal();
                return new BoundingBox(bb[0], bb[1], bb[2] - bb[0], bb[3] - bb[1]);
            }
        };
    }

    public double[] computeContentBoundsInLocal() {
        Bounds diagramBoundsInCanvas = this.contentGroup.getBoundsInParent();
        double minX = diagramBoundsInCanvas.getMinX();
        double maxX = diagramBoundsInCanvas.getMaxX();
        double minY = diagramBoundsInCanvas.getMinY();
        double maxY = diagramBoundsInCanvas.getMaxY();
        Point2D minInScrolled = this.getScrolledPane().localToParent(minX, minY);
        double realMinX = minInScrolled.getX();
        double realMinY = minInScrolled.getY();
        double realMaxX = realMinX + (maxX - minX);
        double realMaxY = realMinY + (maxY - minY);
        return new double[]{realMinX, realMinY, realMaxX, realMaxY};
    }

    public double computeHv(double tx) {
        return this.lerp(this.horizontalScrollBar.getMin(), this.horizontalScrollBar.getMax(), this.norm(this.currentScrollableBounds[0], this.currentScrollableBounds[2] - this.getWidth(), -tx));
    }

    public double[] computeScrollableBoundsInLocal() {
        double[] cb = this.computeContentBoundsInLocal();
        Bounds db = this.contentGroup.getBoundsInParent();
        if (cb[0] < 0.0) {
            cb[0] = 0.0;
        }
        if (cb[1] < 0.0) {
            cb[1] = 0.0;
        }
        cb[2] = cb[2] > this.getWidth() ? 0.0 : this.getWidth() - cb[2];
        cb[3] = cb[3] > this.getHeight() ? 0.0 : this.getHeight() - cb[3];
        return new double[]{db.getMinX() - cb[0], db.getMinY() - cb[1], db.getMaxX() + cb[2], db.getMaxY() + cb[3]};
    }

    public double computeTx(double hv) {
        return -this.lerp(this.currentScrollableBounds[0], this.currentScrollableBounds[2] - this.getWidth(), this.norm(this.horizontalScrollBar.getMin(), this.horizontalScrollBar.getMax(), hv));
    }

    public double computeTy(double vv) {
        return -this.lerp(this.currentScrollableBounds[1], this.currentScrollableBounds[3] - this.getHeight(), this.norm(this.verticalScrollBar.getMin(), this.verticalScrollBar.getMax(), vv));
    }

    public double computeVv(double ty) {
        return this.lerp(this.verticalScrollBar.getMin(), this.verticalScrollBar.getMax(), this.norm(this.currentScrollableBounds[1], this.currentScrollableBounds[3] - this.getHeight(), -ty));
    }

    protected Group createContentGroup() {
        Group g = new Group();
        g.getTransforms().add((Object)this.viewportTransform);
        g.boundsInParentProperty().addListener(this.contentBoundsInParentChangeListener);
        return g;
    }

    protected Group createScrollbarGroup() {
        this.horizontalScrollBar = new ScrollBar();
        this.horizontalScrollBar.setVisible(false);
        this.horizontalScrollBar.setOpacity(0.5);
        this.verticalScrollBar = new ScrollBar();
        this.verticalScrollBar.setOrientation(Orientation.VERTICAL);
        this.verticalScrollBar.setVisible(false);
        this.verticalScrollBar.setOpacity(0.5);
        DoubleBinding vWidth = new DoubleBinding(){
            {
                this.bind(new Observable[]{ScrollPaneEx.this.verticalScrollBar.visibleProperty(), ScrollPaneEx.this.verticalScrollBar.widthProperty()});
            }

            protected double computeValue() {
                return ScrollPaneEx.this.verticalScrollBar.isVisible() ? ScrollPaneEx.this.verticalScrollBar.getWidth() : 0.0;
            }
        };
        this.horizontalScrollBar.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)vWidth));
        this.horizontalScrollBar.layoutYProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.horizontalScrollBar.heightProperty()));
        DoubleBinding hHeight = new DoubleBinding(){
            {
                this.bind(new Observable[]{ScrollPaneEx.this.horizontalScrollBar.visibleProperty(), ScrollPaneEx.this.horizontalScrollBar.heightProperty()});
            }

            protected double computeValue() {
                return ScrollPaneEx.this.horizontalScrollBar.isVisible() ? ScrollPaneEx.this.horizontalScrollBar.getHeight() : 0.0;
            }
        };
        this.verticalScrollBar.prefHeightProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)hHeight));
        this.verticalScrollBar.layoutXProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.verticalScrollBar.widthProperty()));
        this.registerInOutTransitions((Node)this.horizontalScrollBar);
        this.registerInOutTransitions((Node)this.verticalScrollBar);
        EventHandler<MouseEvent> mousePressFilter = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ScrollPaneEx.this.updateScrollbars();
            }
        };
        this.horizontalScrollBar.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)mousePressFilter);
        this.verticalScrollBar.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)mousePressFilter);
        this.horizontalScrollBar.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (ScrollPaneEx.this.horizontalScrollBar.isVisible()) {
                    ScrollPaneEx.this.getScrolledPane().setTranslateX(ScrollPaneEx.this.computeTx(newValue.doubleValue()));
                }
            }
        });
        this.verticalScrollBar.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (ScrollPaneEx.this.verticalScrollBar.isVisible()) {
                    ScrollPaneEx.this.getScrolledPane().setTranslateY(ScrollPaneEx.this.computeTy(newValue.doubleValue()));
                }
            }
        });
        EventHandler<MouseEvent> mouseReleasedHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ScrollPaneEx.this.updateScrollbars();
            }
        };
        this.horizontalScrollBar.setOnMouseReleased((EventHandler)mouseReleasedHandler);
        this.verticalScrollBar.setOnMouseReleased((EventHandler)mouseReleasedHandler);
        return new Group(new Node[]{this.horizontalScrollBar, this.verticalScrollBar});
    }

    protected Pane createScrolledPane() {
        Pane canvas = new Pane();
        canvas.getChildren().add((Object)this.getContentGroup());
        return canvas;
    }

    public double getBottomExcess(Node child) {
        Bounds bounds = this.getBoundsInViewport(child);
        return bounds.getMaxY() - this.getHeight();
    }

    public Bounds getBoundsInViewport(Node child) {
        return this.sceneToLocal(child.localToScene(child.getBoundsInLocal()));
    }

    public ObjectBinding<Bounds> getContentBoundsBinding() {
        return this.contentBoundsBinding;
    }

    public Group getContentGroup() {
        if (this.contentGroup == null) {
            this.contentGroup = this.createContentGroup();
        }
        return this.contentGroup;
    }

    public ScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    public double getLeftExcess(Node child) {
        Bounds bounds = this.getBoundsInViewport(child);
        return -bounds.getMinX();
    }

    public double getRightExcess(Node child) {
        Bounds bounds = this.getBoundsInViewport(child);
        return bounds.getMaxX() - this.getWidth();
    }

    public ObjectBinding<Bounds> getScrollableBoundsBinding() {
        return this.scrollableBoundsBinding;
    }

    public Group getScrollbarGroup() {
        if (this.scrollbarGroup == null) {
            this.scrollbarGroup = this.createScrollbarGroup();
        }
        return this.scrollbarGroup;
    }

    public Pane getScrolledPane() {
        if (this.scrolledPane == null) {
            this.scrolledPane = this.createScrolledPane();
        }
        return this.scrolledPane;
    }

    public double getScrollOffsetX() {
        return this.getScrolledPane().getTranslateX();
    }

    public double getScrollOffsetY() {
        return this.getScrolledPane().getTranslateY();
    }

    public double getTopExcess(Node child) {
        Bounds bounds = this.getBoundsInViewport(child);
        return -bounds.getMinY();
    }

    public ScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public Affine getViewportTransform() {
        return this.viewportTransform;
    }

    public boolean isFullyVisible(Node child) {
        Bounds bounds = this.getBoundsInViewport(child);
        return bounds.getMinX() >= 0.0 && bounds.getMaxX() <= this.getWidth() && bounds.getMinY() >= 0.0 && bounds.getMaxY() <= this.getHeight();
    }

    public boolean isVisible(Node child) {
        Bounds bounds = this.getBoundsInViewport(child);
        return bounds.getMaxX() >= 0.0 && bounds.getMinX() <= this.getWidth() && bounds.getMaxY() >= 0.0 && bounds.getMinY() <= this.getHeight();
    }

    private double lerp(double min, double max, double ratio) {
        double d = (1.0 - ratio) * min + ratio * max;
        return Double.isNaN(d) ? 0.0 : Math.min(max, Math.max(min, d));
    }

    public double lerpHvRatio(double hvRatio) {
        return this.lerp(this.horizontalScrollBar.getMin(), this.horizontalScrollBar.getMax(), hvRatio);
    }

    public double lerpVvRatio(double vvRatio) {
        return this.lerp(this.verticalScrollBar.getMin(), this.verticalScrollBar.getMax(), vvRatio);
    }

    private double norm(double min, double max, double value) {
        double d = (value - min) / (max - min);
        return Double.isNaN(d) ? 0.0 : Math.min(1.0, Math.max(0.0, d));
    }

    public double normHv(double hv) {
        return this.norm(this.horizontalScrollBar.getMin(), this.horizontalScrollBar.getMax(), hv);
    }

    public double normVv(double vv) {
        return this.norm(this.verticalScrollBar.getMin(), this.verticalScrollBar.getMax(), vv);
    }

    private void registerInOutTransitions(final Node node) {
        final FadeTransition fadeInTransition = new FadeTransition(Duration.millis((double)200.0), node);
        fadeInTransition.setToValue(1.0);
        final FadeTransition fadeOutTransition = new FadeTransition(Duration.millis((double)200.0), node);
        fadeOutTransition.setToValue(0.5);
        final Runnable fadeIn = new Runnable(){

            @Override
            public void run() {
                fadeOutTransition.stop();
                fadeInTransition.playFromStart();
            }
        };
        final Runnable fadeOut = new Runnable(){

            @Override
            public void run() {
                fadeInTransition.stop();
                fadeOutTransition.playFromStart();
            }
        };
        node.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                fadeIn.run();
            }
        });
        node.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!node.isPressed()) {
                    fadeOut.run();
                }
            }
        });
        node.pressedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (oldValue.booleanValue() && !newValue.booleanValue()) {
                    fadeOut.run();
                }
            }
        });
    }

    public void reveal(Node child) {
        Bounds bounds = this.getBoundsInViewport(child);
        if (bounds.getHeight() <= this.getHeight()) {
            if (bounds.getMinY() < 0.0) {
                this.setScrollOffsetY(this.getScrollOffsetY() - bounds.getMinY());
            } else if (bounds.getMaxY() > this.getHeight()) {
                this.setScrollOffsetY(this.getScrollOffsetY() + this.getHeight() - bounds.getMaxY());
            }
        }
        if (bounds.getWidth() <= this.getWidth()) {
            if (bounds.getMinX() < 0.0) {
                this.setScrollOffsetX(this.getScrollOffsetX() - bounds.getMinX());
            } else if (bounds.getMaxX() > this.getWidth()) {
                this.setScrollOffsetX(this.getScrollOffsetX() + this.getWidth() - bounds.getMaxX());
            }
        }
    }

    public void setScrollOffsetX(double scrollOffsetX) {
        this.updateScrollbars();
        double hv = this.computeHv(scrollOffsetX);
        if (hv < this.horizontalScrollBar.getMin() || hv > this.horizontalScrollBar.getMax()) {
            throw new IllegalArgumentException("Horizontal scrolling offset outside range [" + this.horizontalScrollBar.getMin() + ";" + this.horizontalScrollBar.getMax() + "]");
        }
        this.getScrolledPane().setTranslateX(scrollOffsetX);
    }

    public void setScrollOffsetY(double scrollOffsetY) {
        this.updateScrollbars();
        double vv = this.computeVv(scrollOffsetY);
        if (vv < this.verticalScrollBar.getMin() || vv > this.verticalScrollBar.getMax()) {
            throw new IllegalArgumentException("Vertical scrolling offset outside range [" + this.verticalScrollBar.getMin() + ";" + this.verticalScrollBar.getMax() + "]");
        }
        this.getScrolledPane().setTranslateY(scrollOffsetY);
    }

    public void setViewportTransform(Affine tx) {
        this.viewportTransform.setMxx(tx.getMxx());
        this.viewportTransform.setMxy(tx.getMxy());
        this.viewportTransform.setMyx(tx.getMyx());
        this.viewportTransform.setMyy(tx.getMyy());
        this.viewportTransform.setTx(tx.getTx());
        this.viewportTransform.setTy(tx.getTy());
        this.updateScrollbars();
        this.contentBoundsBinding.invalidate();
        this.scrollableBoundsBinding.invalidate();
    }

    protected void updateScrollbars() {
        if (this.horizontalScrollBar.isPressed() || this.verticalScrollBar.isPressed()) {
            return;
        }
        double[] contentBounds = this.computeContentBoundsInLocal();
        if (contentBounds[0] < 0.0 || contentBounds[2] > this.getWidth()) {
            this.horizontalScrollBar.setVisible(true);
        } else {
            this.horizontalScrollBar.setVisible(false);
        }
        if (contentBounds[1] < 0.0 || contentBounds[3] > this.getHeight()) {
            this.verticalScrollBar.setVisible(true);
        } else {
            this.verticalScrollBar.setVisible(false);
        }
        double[] bounds = this.computeScrollableBoundsInLocal();
        int i = 0;
        while (i < bounds.length) {
            this.currentScrollableBounds[i] = bounds[i];
            ++i;
        }
        this.horizontalScrollBar.setMin(this.currentScrollableBounds[0]);
        this.horizontalScrollBar.setMax(this.currentScrollableBounds[2]);
        this.horizontalScrollBar.setVisibleAmount(this.getWidth());
        this.horizontalScrollBar.setBlockIncrement(this.getWidth() / 2.0);
        this.horizontalScrollBar.setUnitIncrement(this.getWidth() / 10.0);
        this.verticalScrollBar.setMin(this.currentScrollableBounds[1]);
        this.verticalScrollBar.setMax(this.currentScrollableBounds[3]);
        this.verticalScrollBar.setVisibleAmount(this.getHeight());
        this.verticalScrollBar.setBlockIncrement(this.getHeight() / 2.0);
        this.verticalScrollBar.setUnitIncrement(this.getHeight() / 10.0);
        this.horizontalScrollBar.setValue(this.computeHv(this.getScrolledPane().getTranslateX()));
        this.verticalScrollBar.setValue(this.computeVv(this.getScrolledPane().getTranslateY()));
    }
}

