/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.gef4.geometry.planar.AbstractGeometry;
import org.eclipse.gef4.geometry.planar.CurveUtils;
import org.eclipse.gef4.geometry.planar.IMultiShape;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Polyline;
import org.eclipse.gef4.internal.geometry.utils.PrecisionUtils;

abstract class AbstractMultiShape
extends AbstractGeometry
implements IMultiShape {
    private static final long serialVersionUID = 1L;

    AbstractMultiShape() {
    }

    private static int comparePoints(Point o1, Point o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1.x < o2.x) {
            return -1;
        }
        if (o1.x == o2.x && o1.y < o2.y) {
            return -1;
        }
        return 1;
    }

    private void assignRemainingSegment(HashMap<Line, Integer> seen, Stack<Line> addends, Line toAdd, Point start, Point end) {
        if (!start.equals(end)) {
            Line rest = new Line(start, end);
            if (start.equals(toAdd.getP1()) || start.equals(toAdd.getP2())) {
                addends.push(rest);
            } else {
                seen.put(rest, seen.containsKey(rest) && seen.get(rest) == 2 ? 2 : 1);
            }
        }
    }

    @Override
    public boolean contains(Point p) {
        IShape[] iShapeArray = this.getShapes();
        int n = iShapeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IShape s = iShapeArray[n2];
            if (s.contains(p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void filterOutInnerSegments(HashMap<Line, Integer> seen) {
        for (Line seg : new HashSet<Line>(seen.keySet())) {
            if (seen.get(seg) != 2) continue;
            seen.remove(seg);
        }
    }

    private Polyline findOutline(Set<Line> outlineSegments, Map<Point, List<Line>> segsAt) {
        HashSet<Point> visited = new HashSet<Point>();
        Line initial = outlineSegments.iterator().next();
        List<Point> way = this.findWay(segsAt, visited, initial.getP1(), initial.getP2(), 1);
        if (way == null) {
            return new Polyline(new Line[]{initial});
        }
        way.add(0, initial.getP1());
        return new Polyline(CurveUtils.toSegmentsArray(way.toArray(new Point[0]), true));
    }

    private List<Point> findWay(Map<Point, List<Line>> segmentsByEndPoints, Set<Point> visited, Point start, Point end, int indent) {
        if (segmentsByEndPoints.get(end) == segmentsByEndPoints.get(start)) {
            return new ArrayList<Point>(0);
        }
        visited.add(start);
        List nextSegs = (List)((ArrayList)segmentsByEndPoints.get(start)).clone();
        Iterator i = nextSegs.iterator();
        while (i.hasNext()) {
            Line l = (Line)i.next();
            if (l.getP1().equals(start)) {
                if (!visited.contains(l.getP2())) continue;
                i.remove();
                continue;
            }
            if (!visited.contains(l.getP1())) continue;
            i.remove();
        }
        if (nextSegs.size() == 0) {
            return null;
        }
        if (nextSegs.size() == 1) {
            Line nextSeg = (Line)nextSegs.get(0);
            Point nextPoint = start.equals(nextSeg.getP1()) ? nextSeg.getP2() : nextSeg.getP1();
            List<Point> way = this.findWay(segmentsByEndPoints, visited, nextPoint, end, indent + 1);
            if (way != null) {
                way.add(0, nextPoint);
            }
            return way;
        }
        int longestWayLength = -1;
        List<Point> longestWay = null;
        for (Line nextSeg : nextSegs) {
            Point nextPoint;
            Set visitedCopy = (Set)((HashSet)visited).clone();
            List<Point> way = this.findWay(segmentsByEndPoints, visitedCopy, nextPoint = start.equals(nextSeg.getP1()) ? nextSeg.getP2() : nextSeg.getP1(), end, indent + 1);
            if (way == null || way.size() < longestWayLength) continue;
            way.add(0, nextPoint);
            longestWay = way;
            longestWayLength = way.size();
        }
        return longestWay;
    }

    protected abstract Line[] getAllEdges();

    public Polyline[] getOutlines() {
        ArrayList<Polyline> outlines = new ArrayList<Polyline>();
        HashMap<Point, List<Line>> segmentsByEndPoints = new HashMap<Point, List<Line>>();
        HashSet<Line> outlineSegments = new HashSet<Line>();
        Line[] lineArray = this.getOutlineSegments();
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line seg = lineArray[n2];
            outlineSegments.add(seg);
            ++n2;
        }
        for (Line seg : outlineSegments) {
            if (!segmentsByEndPoints.containsKey(seg.getP1())) {
                ArrayList segList = new ArrayList();
                segmentsByEndPoints.put(seg.getP1(), segList);
            }
            if (!segmentsByEndPoints.containsKey(seg.getP2())) {
                ArrayList segList = new ArrayList();
                segmentsByEndPoints.put(seg.getP2(), segList);
            }
            ((List)segmentsByEndPoints.get(seg.getP1())).add(seg);
            ((List)segmentsByEndPoints.get(seg.getP2())).add(seg);
        }
        for (Point p : segmentsByEndPoints.keySet()) {
            List segments = (List)segmentsByEndPoints.get(p);
            if (segments.size() >= 2) continue;
            throw new IllegalStateException("There is an end point (" + p + ") which is not connected to two segments!");
        }
        while (!outlineSegments.isEmpty()) {
            Polyline outline = this.findOutline(outlineSegments, segmentsByEndPoints);
            outlines.add(outline);
            Line[] lineArray2 = CurveUtils.toSegmentsArray(outline.getPoints(), false);
            int n3 = lineArray2.length;
            n = 0;
            while (n < n3) {
                Line outlineSeg = lineArray2[n];
                if (AbstractMultiShape.comparePoints(outlineSeg.getP1(), outlineSeg.getP2()) == 1) {
                    outlineSeg = new Line(outlineSeg.getP2(), outlineSeg.getP1());
                }
                outlineSegments.remove(outlineSeg);
                ++n;
            }
        }
        return outlines.toArray(new Polyline[0]);
    }

    public Line[] getOutlineSegments() {
        HashMap<Line, Integer> seen = new HashMap<Line, Integer>();
        Stack<Line> elementsToAdd = new Stack<Line>();
        Line[] lineArray = this.getAllEdges();
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line e = lineArray[n2];
            elementsToAdd.push(e);
            ++n2;
        }
        block1: while (!elementsToAdd.empty()) {
            Line toAdd = (Line)elementsToAdd.pop();
            for (Line seg : new HashSet<Line>(seen.keySet())) {
                if (!seg.overlaps(toAdd)) continue;
                Point[] p = this.getSortedEndpoints(toAdd, seg);
                seen.remove(seg);
                this.assignRemainingSegment(seen, elementsToAdd, toAdd, p[0], p[1]);
                this.assignRemainingSegment(seen, elementsToAdd, toAdd, p[3], p[2]);
                this.markOverlap(seen, p[1], p[2]);
                continue block1;
            }
            seen.put(toAdd, 1);
        }
        this.filterOutInnerSegments(seen);
        return seen.keySet().toArray(new Line[0]);
    }

    private Point[] getSortedEndpoints(Line toAdd, Line seg) {
        Point[] p = new Point[]{seg.getP1(), seg.getP2(), toAdd.getP1(), toAdd.getP2()};
        Arrays.sort(p, new Comparator<Point>(){

            @Override
            public int compare(Point p1, Point p2) {
                if (PrecisionUtils.equal(p1.x, p2.x)) {
                    return p1.y < p2.y ? 1 : -1;
                }
                return p1.x < p2.x ? 1 : -1;
            }
        });
        return p;
    }

    private void markOverlap(HashMap<Line, Integer> seen, Point start, Point end) {
        if (!start.equals(end)) {
            Line overlap = new Line(start, end);
            seen.put(overlap, 2);
        }
    }

    @Override
    public Path toPath() {
        Polyline[] outlines = this.getOutlines();
        if (outlines == null || outlines.length < 1) {
            return new Path();
        }
        Path path = outlines[0].toPath();
        int i = 1;
        while (i < outlines.length) {
            path = Path.exclusiveOr(path, outlines[i].toPath());
            ++i;
        }
        return path;
    }
}

