/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.io.Serializable;
import org.eclipse.gef4.internal.geometry.utils.PrecisionUtils;

public class Dimension
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public double width;
    public double height;

    public static Dimension max(Dimension d1, Dimension d2) {
        return new Dimension(Math.max(d1.width, d2.width), Math.max(d1.height, d2.height));
    }

    public static Dimension min(Dimension d1, Dimension d2) {
        return new Dimension(Math.min(d1.width, d2.width), Math.min(d1.height, d2.height));
    }

    public Dimension() {
    }

    public Dimension(Dimension d) {
        this.width = d.width;
        this.height = d.height;
    }

    public Dimension(double w, double h) {
        this.width = w;
        this.height = h;
    }

    public Dimension clone() {
        return this.getCopy();
    }

    public boolean contains(Dimension d) {
        return PrecisionUtils.greaterEqual(this.width, d.width) && PrecisionUtils.greaterEqual(this.height, d.height);
    }

    public boolean equals(double width, double height) {
        return PrecisionUtils.equal(this.width, width) && PrecisionUtils.equal(this.height, height);
    }

    public boolean equals(Object o) {
        if (o instanceof Dimension) {
            Dimension d = (Dimension)o;
            return this.equals(d.width, d.height);
        }
        return false;
    }

    public Dimension expand(Dimension d) {
        return this.expand(d.width, d.height);
    }

    public Dimension expand(double w, double h) {
        this.width += w;
        this.height += h;
        return this;
    }

    public Dimension getCopy() {
        return new Dimension(this);
    }

    public Dimension getExpanded(Dimension d) {
        return this.getCopy().expand(d);
    }

    public Dimension getExpanded(double w, double h) {
        return this.getCopy().expand(w, h);
    }

    public double getHeight() {
        return this.height;
    }

    public Dimension getIntersected(Dimension d) {
        return this.getCopy().intersect(d);
    }

    public Dimension getNegated() {
        return this.getCopy().negate();
    }

    public Dimension getScaled(double amount) {
        return this.getCopy().scale(amount);
    }

    public Dimension getScaled(double widthFactor, double heightFactor) {
        return this.getCopy().scale(widthFactor, heightFactor);
    }

    public Dimension getShrinked(Dimension d) {
        return this.getCopy().shrink(d);
    }

    public Dimension getShrinked(double w, double h) {
        return this.getCopy().shrink(w, h);
    }

    public Dimension getTransposed() {
        return this.getCopy().transpose();
    }

    public Dimension getUnioned(Dimension d) {
        return this.getCopy().union(d);
    }

    public double getWidth() {
        return this.width;
    }

    public int hashCode() {
        return 0;
    }

    public Dimension intersect(Dimension d) {
        this.width = Math.min(d.width, this.width);
        this.height = Math.min(d.height, this.height);
        return this;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public Dimension negate() {
        return this.scale(-1.0);
    }

    public Dimension scale(double factor) {
        return this.scale(factor, factor);
    }

    public Dimension scale(double widthFactor, double heightFactor) {
        this.width *= widthFactor;
        this.height *= heightFactor;
        return this;
    }

    public Dimension setHeight(int height) {
        this.height = height;
        return this;
    }

    public Dimension setSize(Dimension d) {
        this.width = d.width;
        this.height = d.height;
        return this;
    }

    public Dimension setSize(double w, double h) {
        this.width = w;
        this.height = h;
        return this;
    }

    public Dimension setWidth(double width) {
        this.width = width;
        return this;
    }

    public Dimension shrink(Dimension d) {
        return this.shrink(d.width, d.height);
    }

    public Dimension shrink(double w, double h) {
        this.width -= w;
        this.height -= h;
        return this;
    }

    public String toString() {
        return "Dimension(" + this.width + ", " + this.height + ")";
    }

    public Dimension transpose() {
        double temp = this.width;
        this.width = this.height;
        this.height = temp;
        return this;
    }

    public Dimension union(Dimension d) {
        this.width = Math.max(this.width, d.width);
        this.height = Math.max(this.height, d.height);
        return this;
    }
}

