/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.nodes.FXGeometryNode;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.mvc.examples.logo.model.AbstractFXGeometricElement;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricShape;
import org.eclipse.gef4.mvc.examples.logo.parts.AbstractFXGeometricElementPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXGeometricShapePart
extends AbstractFXGeometricElementPart<FXGeometryNode<IShape>> {
    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
    }

    public void attachToContentAnchorage(Object contentAnchorage, String role) {
        if (!(contentAnchorage instanceof AbstractFXGeometricElement)) {
            throw new IllegalArgumentException("Cannot attach to content anchorage: wrong type!");
        }
        this.getContent().getAnchorages().add((AbstractFXGeometricElement)contentAnchorage);
    }

    protected FXGeometryNode<IShape> createVisual() {
        return new FXGeometryNode();
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
    }

    public void detachFromContentAnchorage(Object contentAnchorage, String role) {
        this.getContent().getAnchorages().remove(contentAnchorage);
    }

    @Override
    public void doRefreshVisual(FXGeometryNode<IShape> visual) {
        AffineTransform transform;
        FXGeometricShape content = this.getContent();
        if (visual.getGeometry() != content.getGeometry()) {
            visual.setGeometry((IGeometry)((IShape)content.getGeometry()));
        }
        if ((transform = content.getTransform()) != null) {
            Affine affine = (Affine)((Provider)this.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends Affine>>(){}, (String)"transformationProvider"))).get();
            affine.setMxx(transform.getM00());
            affine.setMxy(transform.getM01());
            affine.setMyx(transform.getM10());
            affine.setMyy(transform.getM11());
            affine.setTx(transform.getTranslateX());
            affine.setTy(transform.getTranslateY());
        }
        if (visual.getStroke() != content.getStroke()) {
            visual.setStroke(content.getStroke());
        }
        if (visual.getStrokeWidth() != content.getStrokeWidth()) {
            visual.setStrokeWidth(content.getStrokeWidth());
        }
        if (visual.getFill() != content.getFill()) {
            visual.setFill(content.getFill());
        }
        super.doRefreshVisual(visual);
    }

    @Override
    public FXGeometricShape getContent() {
        return (FXGeometricShape)super.getContent();
    }

    public SetMultimap<? extends Object, String> getContentAnchorages() {
        HashMultimap anchorages = HashMultimap.create();
        for (AbstractFXGeometricElement<? extends IGeometry> anchorage : this.getContent().getAnchorages()) {
            anchorages.put(anchorage, (Object)"link");
        }
        return anchorages;
    }

    public void setContent(Object model) {
        if (model != null && !(model instanceof FXGeometricShape)) {
            throw new IllegalArgumentException("Only IShape models are supported.");
        }
        super.setContent(model);
    }
}

