/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.policies;

import javafx.scene.input.MouseEvent;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.examples.logo.policies.AbstractCloneContentPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXRelocateOnDragPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.policies.CreationPolicy;

public class FXCloneRelocateOnDragPolicy
extends FXRelocateOnDragPolicy {
    private boolean isClone = true;
    private AffineTransform originalTransform;
    private ReverseUndoCompositeOperation cloneOperations;

    private void createClone() {
        this.cloneOperations = new ReverseUndoCompositeOperation("Clone");
        Object cloneContent = ((AbstractCloneContentPolicy)((Object)this.getHost().getAdapter(AbstractCloneContentPolicy.class))).cloneContent();
        IRootPart root = this.getHost().getRoot();
        CreationPolicy creationPolicy = (CreationPolicy)root.getAdapter(CreationPolicy.class);
        creationPolicy.init();
        creationPolicy.create((IContentPart)this.getHost().getParent(), cloneContent);
        this.cloneOperations.add(creationPolicy.commit());
        this.cloneOperations.add((IUndoableOperation)new CopyTransformOperation(cloneContent));
    }

    public void drag(MouseEvent e, Dimension delta) {
        boolean wasClone = this.isClone;
        this.isClone = this.isCloneModifierDown(e);
        if (!wasClone && this.isClone) {
            this.createClone();
            try {
                this.cloneOperations.execute(null, null);
            }
            catch (ExecutionException x) {
                x.printStackTrace();
            }
        } else if (wasClone && !this.isClone) {
            this.removeClone();
        }
        super.drag(e, delta);
    }

    protected boolean isCloneModifierDown(MouseEvent e) {
        return e.isAltDown() || e.isShiftDown();
    }

    public void press(MouseEvent e) {
        this.originalTransform = JavaFX2Geometry.toAffineTransform((Transform)((FXTransformPolicy)this.getHost().getAdapter(FXTransformPolicy.class)).getNodeTransform());
        this.isClone = false;
        super.press(e);
    }

    public void release(MouseEvent e, Dimension delta) {
        if (this.isCloneModifierDown(e)) {
            this.removeClone();
            this.createClone();
            this.getHost().getRoot().getViewer().getDomain().execute((IUndoableOperation)this.cloneOperations);
        }
        super.release(e, delta);
    }

    private void removeClone() {
        if (this.cloneOperations == null) {
            return;
        }
        try {
            this.cloneOperations.undo(null, null);
            this.cloneOperations = null;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    class CopyTransformOperation
    extends AbstractOperation {
        private final Object targetContent;
        private IUndoableOperation operation;

        public CopyTransformOperation(Object targetContent) {
            super("CopyTransform");
            this.targetContent = targetContent;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.operation == null) {
                IContentPart cloneContentPart = (IContentPart)FXCloneRelocateOnDragPolicy.this.getHost().getRoot().getViewer().getContentPartMap().get(this.targetContent);
                FXTransformPolicy cloneTransformPolicy = (FXTransformPolicy)cloneContentPart.getAdapter(FXTransformPolicy.class);
                cloneTransformPolicy.init();
                cloneTransformPolicy.setTransform(FXCloneRelocateOnDragPolicy.this.originalTransform);
                this.operation = cloneTransformPolicy.commit();
            }
            return this.operation.execute(null, null);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.operation.undo(monitor, info);
        }
    }
}

