/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionForwarder<VR>
implements PropertyChangeListener,
ISelectionChangedListener {
    private final ISelectionProvider selectionProvider;
    private final IViewer<VR> viewer;
    private final SelectionModel<VR> selectionModel;

    public SelectionForwarder(ISelectionProvider selectionProvider, IViewer<VR> viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException("The given IViewer<VR> may not be null.");
        }
        this.selectionProvider = selectionProvider;
        this.viewer = viewer;
        this.selectionModel = (SelectionModel)viewer.getAdapter(SelectionModel.class);
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.selectionModel != null) {
            this.selectionModel.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void dispose() {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.selectionModel != null) {
            this.selectionModel.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("selection".equals(event.getPropertyName())) {
            if (event.getNewValue() == null) {
                this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                List selectedParts = (List)event.getNewValue();
                ArrayList<Object> selectedContentElements = new ArrayList<Object>(selectedParts.size());
                for (IContentPart cp : selectedParts) {
                    selectedContentElements.add(cp.getContent());
                }
                this.selectionProvider.setSelection((ISelection)new StructuredSelection(selectedContentElements));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)selection;
            if (sel.isEmpty()) {
                this.selectionModel.select(Collections.emptyList());
            } else {
                Object[] selected = sel.toArray();
                ArrayList<IContentPart> parts = new ArrayList<IContentPart>(selected.length);
                Object[] objectArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    Object content = objectArray[n2];
                    IContentPart part = (IContentPart)this.viewer.getContentPartMap().get(content);
                    if (part != null) {
                        parts.add(part);
                    }
                    ++n2;
                }
                if (!this.selectionModel.getSelected().equals(parts)) {
                    this.selectionModel.select(parts);
                }
            }
        }
    }
}

