/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.properties;

import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;

public abstract class AbstractFXColorPicker
extends Group {
    public static final Color DEFAULT_COLOR = Color.WHITE;
    private SimpleObjectProperty<Color> colorProperty = new SimpleObjectProperty((Object)DEFAULT_COLOR);
    private SimpleObjectProperty<Color> borderColorProperty = new SimpleObjectProperty((Object)Color.GREY);
    private SimpleObjectProperty<Color> backgroundColorProperty = new SimpleObjectProperty((Object)Color.LIGHTGREY);

    private static String toRgbString(Color color) {
        return "rgb(" + (int)(255.0 * color.getRed()) + "," + (int)(255.0 * color.getGreen()) + "," + (int)(255.0 * color.getBlue()) + ")";
    }

    public AbstractFXColorPicker() {
        HBox hbox = new HBox();
        this.getChildren().add((Object)hbox);
        WritableImage colorWheelImage = new WritableImage(64, 64);
        ColorWheel.render(colorWheelImage, 0, 0, 64);
        ImageView colorWheel = new ImageView((Image)colorWheelImage);
        colorWheel.setFitWidth(16.0);
        colorWheel.setFitHeight(16.0);
        BorderPane buttonPane = new BorderPane();
        Insets insets = new Insets(2.0);
        buttonPane.setPadding(insets);
        buttonPane.setCenter((Node)colorWheel);
        Line l = new Line();
        l.setStartX(0.0);
        l.setStartY(0.0);
        l.setEndX(0.0);
        l.endYProperty().bind((ObservableValue)buttonPane.heightProperty());
        Rectangle colorRect = new Rectangle(50.0, 20.0);
        colorRect.widthProperty().bind((ObservableValue)colorWheel.fitWidthProperty().add(insets.getLeft()).add(insets.getRight()).multiply(2.5).subtract((ObservableNumberValue)l.strokeWidthProperty()));
        colorRect.heightProperty().bind((ObservableValue)buttonPane.heightProperty());
        colorRect.fillProperty().bind(this.colorProperty);
        l.strokeProperty().bind(this.borderColorProperty);
        hbox.styleProperty().bind((ObservableValue)new StringBinding(){
            {
                this.bind(new Observable[]{AbstractFXColorPicker.this.borderColorProperty, AbstractFXColorPicker.this.backgroundColorProperty});
            }

            protected String computeValue() {
                return "-fx-border-color: " + AbstractFXColorPicker.toRgbString((Color)AbstractFXColorPicker.this.borderColorProperty.get()) + "; -fx-background-color: " + AbstractFXColorPicker.toRgbString((Color)AbstractFXColorPicker.this.backgroundColorProperty.get());
            }
        });
        hbox.getChildren().addAll((Object[])new Node[]{colorRect, l, buttonPane});
        buttonPane.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Color colorOrNull = AbstractFXColorPicker.this.pickColor();
                if (colorOrNull != null) {
                    AbstractFXColorPicker.this.setColor(colorOrNull);
                }
            }
        });
    }

    public abstract Color pickColor();

    public ObjectProperty<Color> colorProperty() {
        return this.colorProperty;
    }

    public Color getColor() {
        return (Color)this.colorProperty.get();
    }

    public void setColor(Color color) {
        this.colorProperty.set((Object)color);
    }

    public ObjectProperty<Color> borderColorProperty() {
        return this.borderColorProperty;
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        return this.backgroundColorProperty;
    }

    public static class ColorWheel {
        public static void render(WritableImage image, int offsetX, int offsetY, int size) {
            PixelWriter px = image.getPixelWriter();
            double radius = size / 2;
            Point2D mid = new Point2D(radius, radius);
            int y = 0;
            while (y < size) {
                int x = 0;
                while (x < size) {
                    double d = mid.distance((double)x, (double)y);
                    if (d <= radius) {
                        double angleRad = d == 0.0 ? 0.0 : Math.atan2((double)y - mid.getY(), (double)x - mid.getX());
                        double sat = d / radius;
                        Color color = Color.hsb((double)(angleRad * 180.0 / Math.PI), (double)sat, (double)1.0);
                        px.setColor(offsetX + x, offsetY + y, color);
                    } else {
                        px.setColor(offsetX + x, offsetY + y, Color.TRANSPARENT);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }
}

