/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import org.eclipse.gef4.common.properties.IPropertyChangeNotifier;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class FXAdvancedGradientPicker
implements IPropertyChangeNotifier {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Paint advancedGradient;
    private Control control;

    public FXAdvancedGradientPicker(Composite parent) {
        this.control = this.createControl(parent);
        this.setAdvancedGradient((Paint)FXAdvancedGradientPicker.createAdvancedLinearGradient(Color.WHITE, Color.GREY, Color.BLACK));
    }

    public Control getControl() {
        return this.control;
    }

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        FXCanvas canvas = new FXCanvas(composite, 0);
        HBox root = new HBox();
        Rectangle r = new Rectangle(20.0, 30.0);
        r.setFill((Paint)Color.RED);
        root.getChildren().add((Object)r);
        Scene scene = new Scene((Parent)root);
        canvas.setScene(scene);
        return composite;
    }

    public void setAdvancedGradient(Paint advancedGradient) {
        if (!FXAdvancedGradientPicker.isAdvancedGradient(advancedGradient)) {
            throw new IllegalArgumentException("Given value '" + advancedGradient + "' is no advanced gradient");
        }
        Paint oldAdvancedGradient = this.advancedGradient;
        this.advancedGradient = advancedGradient;
        this.pcs.firePropertyChange("simpleGradient", oldAdvancedGradient, advancedGradient);
    }

    public Paint getAdvancedGradient() {
        return this.advancedGradient;
    }

    protected static LinearGradient createAdvancedLinearGradient(Color c1, Color c2, Color c3) {
        Stop[] stops = new Stop[]{new Stop(0.0, c1), new Stop(0.5, c2), new Stop(1.0, c3)};
        return new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stops);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public static boolean isAdvancedGradient(Paint paint) {
        if (paint instanceof LinearGradient) {
            return ((LinearGradient)paint).getStops().size() > 2;
        }
        return paint instanceof RadialGradient;
    }
}

