/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javafx.embed.swt.SWTFXUtils;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import org.eclipse.gef4.mvc.fx.ui.properties.FXAdvancedGradientPicker;
import org.eclipse.gef4.mvc.fx.ui.properties.FXColorPicker;
import org.eclipse.gef4.mvc.fx.ui.properties.FXSimpleGradientPicker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FXFillSelectionDialog
extends Dialog {
    private Paint paint;
    private String title;
    private Combo optionsCombo;
    private Label imageLabel;
    private Paint lastFillColor = Color.WHITE;
    private FXColorPicker colorPicker;
    private Paint lastSimpleGradient = FXSimpleGradientPicker.createSimpleGradient(Color.WHITE, Color.BLACK);
    private FXSimpleGradientPicker simpleGradientPicker;
    private Paint lastAdvancedGradient = FXAdvancedGradientPicker.createAdvancedLinearGradient(Color.WHITE, Color.GREY, Color.BLACK);
    private FXAdvancedGradientPicker advancedGradientPicker;

    public FXFillSelectionDialog(Shell parent, String title) {
        super(parent);
        this.title = title;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setFont(parent.getFont());
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gl.marginTop = this.convertVerticalDLUsToPixels(7);
        container.setLayout((Layout)gl);
        container.setBackground(parent.getBackground());
        Composite labelContainer = new Composite(container, 0);
        labelContainer.setLayoutData((Object)new GridData(4, 128, true, false));
        gl = new GridLayout(2, true);
        gl.marginWidth = 3;
        labelContainer.setLayout((Layout)gl);
        Label fillLabel = new Label(labelContainer, 16384);
        fillLabel.setBackground(parent.getBackground());
        fillLabel.setFont(parent.getFont());
        fillLabel.setLayoutData((Object)new GridData());
        fillLabel.setText("Fill:");
        this.imageLabel = new Label(labelContainer, 131072);
        this.imageLabel.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Composite optionsContainer = new Composite(container, 0);
        optionsContainer.setLayoutData((Object)new GridData(4, 128, true, false));
        gl = new GridLayout(1, true);
        gl.marginWidth = 3;
        optionsContainer.setLayout((Layout)gl);
        this.optionsCombo = new Combo(optionsContainer, 2060);
        this.optionsCombo.setItems(new String[]{"No Fill", "Color Fill", "Gradient Fill", "Advanced Gradient Fill"});
        this.optionsCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        final Composite optionsComposite = this.createNoFillComposite(optionsContainer);
        final StackLayout sl = new StackLayout();
        optionsComposite.setLayout((Layout)sl);
        optionsComposite.setLayoutData((Object)new GridData(768, 1, true, false));
        final Composite noFillComposite = this.createNoFillComposite(optionsComposite);
        final Composite colorFillComposite = this.createColorFillComposite(optionsComposite);
        final Composite simpleGradientFillComposite = this.createSimpleGradientFillComposite(optionsComposite);
        final Composite advancedGradientFillComposite = this.createAdvancedGradientFillComposite(optionsComposite);
        this.optionsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FXFillSelectionDialog.this.paint != null) {
                    if (FXFillSelectionDialog.this.paint instanceof Color && !Color.TRANSPARENT.equals((Object)FXFillSelectionDialog.this.paint)) {
                        FXFillSelectionDialog.this.lastFillColor = FXFillSelectionDialog.this.paint;
                    } else if (FXSimpleGradientPicker.isSimpleGradient(FXFillSelectionDialog.this.paint)) {
                        FXFillSelectionDialog.this.lastSimpleGradient = FXFillSelectionDialog.this.paint;
                    } else if (FXAdvancedGradientPicker.isAdvancedGradient(FXFillSelectionDialog.this.paint)) {
                        FXFillSelectionDialog.this.lastAdvancedGradient = FXFillSelectionDialog.this.paint;
                    }
                }
                switch (FXFillSelectionDialog.this.optionsCombo.getSelectionIndex()) {
                    case 0: {
                        sl.topControl = noFillComposite;
                        FXFillSelectionDialog.this.paint = (Paint)Color.TRANSPARENT;
                        break;
                    }
                    case 1: {
                        sl.topControl = colorFillComposite;
                        FXFillSelectionDialog.this.setPaint(FXFillSelectionDialog.this.lastFillColor);
                        FXFillSelectionDialog.this.colorPicker.setColor((Color)FXFillSelectionDialog.this.paint);
                        break;
                    }
                    case 2: {
                        sl.topControl = simpleGradientFillComposite;
                        FXFillSelectionDialog.this.setPaint(FXFillSelectionDialog.this.lastSimpleGradient);
                        FXFillSelectionDialog.this.simpleGradientPicker.setSimpleGradient((LinearGradient)FXFillSelectionDialog.this.paint);
                        break;
                    }
                    case 3: {
                        sl.topControl = advancedGradientFillComposite;
                        FXFillSelectionDialog.this.setPaint(FXFillSelectionDialog.this.lastAdvancedGradient);
                        FXFillSelectionDialog.this.advancedGradientPicker.setAdvancedGradient(FXFillSelectionDialog.this.paint);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported option");
                    }
                }
                FXFillSelectionDialog.this.updateImageLabel();
                optionsComposite.layout();
            }
        });
        if (Color.TRANSPARENT.equals((Object)this.paint)) {
            this.optionsCombo.select(0);
        } else if (this.paint instanceof Color) {
            this.optionsCombo.select(1);
        } else if (FXSimpleGradientPicker.isSimpleGradient(this.paint)) {
            this.optionsCombo.select(2);
        } else if (FXAdvancedGradientPicker.isAdvancedGradient(this.paint)) {
            this.optionsCombo.select(3);
        } else if (this.paint instanceof ImagePattern) {
            this.optionsCombo.select(4);
        }
        return container;
    }

    protected Composite createNoFillComposite(Composite optionsComposite) {
        Composite noFillComposite = new Composite(optionsComposite, 0);
        return noFillComposite;
    }

    public Composite createColorFillComposite(Composite optionsComposite) {
        Composite composite = new Composite(optionsComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        this.colorPicker = new FXColorPicker(composite);
        this.colorPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FXFillSelectionDialog.this.setPaint((Paint)FXFillSelectionDialog.this.colorPicker.getColor());
            }
        });
        return composite;
    }

    protected Composite createSimpleGradientFillComposite(Composite optionsComposite) {
        Composite composite = new Composite(optionsComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        this.simpleGradientPicker = new FXSimpleGradientPicker(composite);
        this.simpleGradientPicker.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.simpleGradientPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FXFillSelectionDialog.this.setPaint((Paint)FXFillSelectionDialog.this.simpleGradientPicker.getSimpleGradient());
            }
        });
        return composite;
    }

    protected Composite createAdvancedGradientFillComposite(Composite optionsComposite) {
        Composite composite = new Composite(optionsComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        this.advancedGradientPicker = new FXAdvancedGradientPicker(composite);
        this.advancedGradientPicker.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.advancedGradientPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FXFillSelectionDialog.this.setPaint(FXFillSelectionDialog.this.advancedGradientPicker.getAdvancedGradient());
            }
        });
        return composite;
    }

    protected void updateImageLabel() {
        if (this.optionsCombo != null && this.imageLabel != null && this.paint != null) {
            ImageData imageData = FXFillSelectionDialog.createPaintImage(64, this.optionsCombo.getItemHeight() - 1, this.paint);
            this.imageLabel.setImage(new org.eclipse.swt.graphics.Image((Device)this.imageLabel.getDisplay(), imageData, imageData.getTransparencyMask()));
        }
    }

    protected static ImageData createPaintImage(int width, int height, Paint paint) {
        Canvas canvas = new Canvas((double)width, (double)height);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.setFill(paint);
        graphicsContext.fillRect(0.0, 0.0, (double)width, (double)height);
        graphicsContext.setStroke((Paint)Color.BLACK);
        graphicsContext.strokeRect(0.0, 0.0, (double)width, (double)height);
        if (paint instanceof Color && ((Color)paint).getOpacity() == 0.0) {
            graphicsContext.setStroke((Paint)Color.RED);
            graphicsContext.strokeLine(0.0, (double)(height - 1), (double)width, 1.0);
        }
        WritableImage snapshot = canvas.snapshot(new SnapshotParameters(), null);
        return SWTFXUtils.fromFXImage((Image)snapshot, null);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public void setPaint(Paint paint) {
        if (this.paint == null) {
            if (paint instanceof Color) {
                if (!Color.TRANSPARENT.equals((Object)paint)) {
                    this.lastFillColor = paint;
                    this.lastSimpleGradient = FXSimpleGradientPicker.createSimpleGradient(Color.WHITE, (Color)paint);
                    this.lastAdvancedGradient = FXAdvancedGradientPicker.createAdvancedLinearGradient(Color.WHITE, ((Color)paint).brighter(), (Color)paint);
                }
            } else if (FXSimpleGradientPicker.isSimpleGradient(paint)) {
                this.lastSimpleGradient = paint;
                List stops = ((LinearGradient)paint).getStops();
                this.lastFillColor = ((Stop)stops.get(1)).getColor();
                this.lastAdvancedGradient = FXAdvancedGradientPicker.createAdvancedLinearGradient(((Stop)stops.get(0)).getColor(), ((Stop)stops.get(1)).getColor().brighter(), ((Stop)stops.get(1)).getColor());
            } else if (FXAdvancedGradientPicker.isAdvancedGradient(paint)) {
                this.lastAdvancedGradient = paint;
                List stops = paint instanceof LinearGradient ? ((LinearGradient)paint).getStops() : ((RadialGradient)paint).getStops();
                this.lastFillColor = ((Stop)stops.get(stops.size() - 1)).getColor();
                this.lastSimpleGradient = FXSimpleGradientPicker.createSimpleGradient(((Stop)stops.get(0)).getColor(), ((Stop)stops.get(stops.size() - 1)).getColor());
            }
        }
        this.paint = paint;
        this.updateImageLabel();
    }

    public Paint getPaint() {
        return this.paint;
    }
}

