/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.mvc.models.ViewportModel;

public class FXChangeViewportOperation
extends AbstractOperation {
    protected ViewportModel viewportModel;
    protected double oldWidth;
    protected double newWidth;
    protected double oldHeight;
    protected double newHeight;
    protected AffineTransform oldTransform;
    protected AffineTransform newTransform;
    protected double oldTx;
    protected double newTx;
    protected double oldTy;
    protected double newTy;

    protected FXChangeViewportOperation(ViewportModel viewportModel) {
        super("ChangeViewport");
        this.readViewport(viewportModel);
    }

    public FXChangeViewportOperation(ViewportModel viewportModel, AffineTransform newTransform) {
        this(viewportModel);
        this.newTransform = newTransform;
    }

    public FXChangeViewportOperation(ViewportModel viewportModel, AffineTransform newTransform, double newTx, double newTy) {
        this(viewportModel);
        this.newTransform = newTransform;
        this.newTx = newTx;
        this.newTy = newTy;
    }

    public FXChangeViewportOperation(ViewportModel viewportModel, AffineTransform newTransform, double newTx, double newTy, double newWidth, double newHeight) {
        this(viewportModel);
        this.newWidth = newWidth;
        this.newHeight = newHeight;
        this.newTransform = newTransform;
        this.newTx = newTx;
        this.newTy = newTy;
    }

    public FXChangeViewportOperation(ViewportModel viewportModel, double newTx, double newTy) {
        this(viewportModel);
        this.newTx = newTx;
        this.newTy = newTy;
    }

    public void concatenateToNewTransform(AffineTransform t) {
        this.newTransform.concatenate(t);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.viewportModel.setWidth(this.newWidth);
        this.viewportModel.setHeight(this.newHeight);
        this.viewportModel.setContentsTransform(this.newTransform);
        this.viewportModel.setTranslateX(this.newTx);
        this.viewportModel.setTranslateY(this.newTy);
        return Status.OK_STATUS;
    }

    protected void readViewport(ViewportModel viewportModel) {
        this.viewportModel = viewportModel;
        this.oldWidth = viewportModel.getWidth();
        this.oldHeight = viewportModel.getHeight();
        this.oldTransform = viewportModel.getContentsTransform();
        this.oldTx = viewportModel.getTranslateX();
        this.oldTy = viewportModel.getTranslateY();
        this.newWidth = this.oldWidth;
        this.newHeight = this.oldHeight;
        this.newTransform = this.oldTransform.getCopy();
        this.newTx = this.oldTx;
        this.newTy = this.oldTy;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.viewportModel.setWidth(this.oldWidth);
        this.viewportModel.setHeight(this.oldHeight);
        this.viewportModel.setContentsTransform(this.oldTransform);
        this.viewportModel.setTranslateX(this.oldTx);
        this.viewportModel.setTranslateY(this.oldTy);
        return Status.OK_STATUS;
    }
}

