/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.operations;

import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;

public class FXResizeNodeOperation
extends AbstractOperation {
    private final Node visual;
    private final Dimension oldSize;
    private double dw;
    private double dh;

    public FXResizeNodeOperation(Node visual) {
        this(visual, 0.0, 0.0);
    }

    public FXResizeNodeOperation(Node visual, double dw, double dh) {
        this("Resize", visual, new Point(visual.getLayoutX() + visual.getLayoutBounds().getMinX(), visual.getLayoutY() + visual.getLayoutBounds().getMinY()), new Dimension(visual.getLayoutBounds().getWidth(), visual.getLayoutBounds().getHeight()), dw, dh);
    }

    public FXResizeNodeOperation(String label, Node visual, Point oldLocation, Dimension oldSize, double dw, double dh) {
        super(label);
        this.visual = visual;
        if (oldSize.width + dw < 0.0) {
            throw new IllegalArgumentException("Cannot resize below zero.");
        }
        if (oldSize.height + dh < 0.0) {
            throw new IllegalArgumentException("Cannot resize below zero.");
        }
        this.oldSize = oldSize.getCopy();
        this.dw = dw;
        this.dh = dh;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.visual.resize(this.oldSize.getWidth() + this.dw, this.oldSize.getHeight() + this.dh);
        return Status.OK_STATUS;
    }

    public double getDh() {
        return this.dh;
    }

    public double getDw() {
        return this.dw;
    }

    public Dimension getOldSize() {
        return this.oldSize;
    }

    public Node getVisual() {
        return this.visual;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setDh(double dh) {
        this.dh = dh;
    }

    public void setDw(double dw) {
        this.dw = dw;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.visual.resize(this.oldSize.getWidth(), this.oldSize.getHeight());
        return Status.OK_STATUS;
    }
}

