/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import java.util.Map;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.eclipse.gef4.mvc.parts.AbstractContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractFXContentPart<V extends Node>
extends AbstractContentPart<Node, V> {
    protected void registerAtVisualPartMap(IViewer<Node> viewer, V visual) {
        super.registerAtVisualPartMap(viewer, visual);
        if (visual instanceof Parent) {
            this.registerNestedVisuals(viewer.getVisualPartMap(), (Parent)visual);
        }
    }

    protected void registerNestedVisuals(Map<Node, IVisualPart<Node, ? extends Node>> visualPartMap, Parent parent) {
        for (Node nestedVisual : parent.getChildrenUnmodifiable()) {
            if (visualPartMap.containsKey(nestedVisual)) continue;
            visualPartMap.put(nestedVisual, (IVisualPart<Node, ? extends Node>)this);
            if (!(nestedVisual instanceof Parent)) continue;
            this.registerNestedVisuals(visualPartMap, (Parent)nestedVisual);
        }
    }

    protected void unregisterFromVisualPartMap(IViewer<Node> viewer, V visual) {
        super.unregisterFromVisualPartMap(viewer, visual);
        if (visual instanceof Parent) {
            this.unregisterNestedVisuals(viewer.getVisualPartMap(), (Parent)visual);
        }
    }

    protected void unregisterNestedVisuals(Map<Node, IVisualPart<Node, ? extends Node>> visualPartMap, Parent parent) {
        for (Node nestedVisual : parent.getChildrenUnmodifiable()) {
            if (!visualPartMap.containsKey(nestedVisual) || visualPartMap.get(nestedVisual) != this) continue;
            visualPartMap.remove(nestedVisual);
            if (!(nestedVisual instanceof Parent)) continue;
            this.unregisterNestedVisuals(visualPartMap, (Parent)nestedVisual);
        }
    }
}

