/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.eclipse.gef4.fx.listeners.VisualChangeListener;
import org.eclipse.gef4.mvc.parts.AbstractHandlePart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public abstract class AbstractFXHandlePart<N extends Node>
extends AbstractHandlePart<Node, N> {
    private final Map<IVisualPart<Node, ? extends Node>, VisualChangeListener> visualChangeListeners = new HashMap<IVisualPart<Node, ? extends Node>, VisualChangeListener>();
    private final Map<IVisualPart<Node, ? extends Node>, Integer> anchorageLinkCount = new HashMap<IVisualPart<Node, ? extends Node>, Integer>();

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        int count;
        int n = count = this.anchorageLinkCount.get(anchorage) == null ? 0 : this.anchorageLinkCount.get(anchorage);
        if (count == 0) {
            VisualChangeListener listener = new VisualChangeListener(){

                protected void boundsInLocalChanged(Bounds oldBounds, Bounds newBounds) {
                    AbstractFXHandlePart.this.refreshVisual();
                }

                protected void localToParentTransformChanged(Node observed, Transform oldTransform, Transform newTransform) {
                    AbstractFXHandlePart.this.refreshVisual();
                }
            };
            this.visualChangeListeners.put(anchorage, listener);
            listener.register((Node)anchorage.getVisual(), (Node)this.getVisual());
        }
        this.anchorageLinkCount.put(anchorage, count + 1);
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        int count = this.anchorageLinkCount.get(anchorage);
        if (count == 1) {
            this.visualChangeListeners.remove(anchorage).unregister();
        }
        if (count > 0) {
            this.anchorageLinkCount.put(anchorage, count - 1);
        } else {
            this.anchorageLinkCount.remove(anchorage);
        }
    }
}

