/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.nodes.FXUtils;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.behaviors.HoverBehavior;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.behaviors.SelectionBehavior;
import org.eclipse.gef4.mvc.fx.parts.FXCircleSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.parts.FXRectangleSegmentHandlePart;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IHandlePartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXDefaultHandlePartFactory
implements IHandlePartFactory<Node> {
    public static final String SELECTION_HANDLES_GEOMETRY_PROVIDER = "SELECTION_HANDLES_GEOMETRY_PROVIDER";
    public static final String HOVER_HANDLES_GEOMETRY_PROVIDER = "HOVER_HANDLES_GEOMETRY_PROVIDER";
    @Inject
    private Injector injector;

    protected IHandlePart<Node, ? extends Node> createBoundsSelectionCornerHandlePart(List<? extends IVisualPart<Node, ? extends Node>> targets, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider, int segmentIndex, double segmentParameter) {
        FXRectangleSegmentHandlePart part = new FXRectangleSegmentHandlePart(segmentsProvider, segmentIndex, segmentParameter);
        this.injector.injectMembers((Object)part);
        return part;
    }

    protected List<IHandlePart<Node, ? extends Node>> createBoundsSelectionHandleParts(List<? extends IVisualPart<Node, ? extends Node>> targets, Provider<? extends IGeometry> handleGeometryProvider, Map<Object, Object> contextMap) {
        ArrayList<IHandlePart<Node, ? extends Node>> handleParts = new ArrayList<IHandlePart<Node, ? extends Node>>();
        Provider<BezierCurve[]> segmentsProvider = this.createSegmentsProvider(handleGeometryProvider);
        int i = 0;
        while (i < 4) {
            IHandlePart<Node, ? extends Node> part = this.createBoundsSelectionCornerHandlePart(targets, contextMap, segmentsProvider, i, 0.0);
            if (part != null) {
                handleParts.add(part);
            }
            ++i;
        }
        return handleParts;
    }

    protected IHandlePart<Node, ? extends Node> createCurveSelectionHandlePart(IVisualPart<Node, ? extends Node> targetPart, Provider<BezierCurve[]> segmentsProvider, int segmentCount, int segmentIndex, double segmentParameter) {
        FXCircleSegmentHandlePart part = new FXCircleSegmentHandlePart(segmentsProvider, segmentIndex, segmentParameter);
        this.injector.injectMembers((Object)part);
        return part;
    }

    protected List<IHandlePart<Node, ? extends Node>> createCurveSelectionHandleParts(IVisualPart<Node, ? extends Node> targetPart, Provider<BezierCurve[]> segmentsProvider, Map<Object, Object> contextMap) {
        ArrayList<IHandlePart<Node, ? extends Node>> hps = new ArrayList<IHandlePart<Node, ? extends Node>>();
        BezierCurve[] segments = (BezierCurve[])segmentsProvider.get();
        int i = 0;
        while (i < segments.length) {
            IHandlePart<Node, ? extends Node> part = this.createCurveSelectionHandlePart(targetPart, segmentsProvider, segments.length, i, 0.0);
            if (part != null) {
                hps.add(part);
            }
            if ((part = this.createCurveSelectionHandlePart(targetPart, segmentsProvider, segments.length, i, 0.5)) != null) {
                hps.add(part);
            }
            if (i == segments.length - 1 && (part = this.createCurveSelectionHandlePart(targetPart, segmentsProvider, segments.length, i, 1.0)) != null) {
                hps.add(part);
            }
            ++i;
        }
        return hps;
    }

    public List<IHandlePart<Node, ? extends Node>> createHandleParts(List<? extends IVisualPart<Node, ? extends Node>> targets, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        if (targets == null || targets.isEmpty()) {
            return Collections.emptyList();
        }
        if (contextBehavior instanceof SelectionBehavior) {
            return this.createSelectionHandleParts(targets, (SelectionBehavior<Node>)((SelectionBehavior)contextBehavior), contextMap);
        }
        if (contextBehavior instanceof HoverBehavior) {
            if (targets.size() > 1) {
                throw new IllegalStateException("Cannot create hover handles for more than one target.");
            }
            return this.createHoverHandleParts(targets.get(0), (HoverBehavior<Node>)((HoverBehavior)contextBehavior), contextMap);
        }
        return Collections.emptyList();
    }

    protected List<IHandlePart<Node, ? extends Node>> createHoverHandleParts(final IVisualPart<Node, ? extends Node> target, HoverBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        IGeometry hoverHandlesGeometry;
        ArrayList<IHandlePart<Node, ? extends Node>> handleParts = new ArrayList<IHandlePart<Node, ? extends Node>>();
        final Provider hoverHandlesGeometryInTargetLocalProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)HOVER_HANDLES_GEOMETRY_PROVIDER));
        IGeometry iGeometry = hoverHandlesGeometry = hoverHandlesGeometryInTargetLocalProvider != null ? (IGeometry)hoverHandlesGeometryInTargetLocalProvider.get() : null;
        if (hoverHandlesGeometry == null) {
            return handleParts;
        }
        Provider<IGeometry> hoverHandlesGeometryInSceneProvider = new Provider<IGeometry>(){

            public IGeometry get() {
                return FXUtils.localToScene((Node)((Node)target.getVisual()), (IGeometry)((IGeometry)hoverHandlesGeometryInTargetLocalProvider.get()));
            }
        };
        Provider<BezierCurve[]> hoverHandlesSegmentsInSceneProvider = new Provider<BezierCurve[]>((Provider)hoverHandlesGeometryInSceneProvider){
            private final /* synthetic */ Provider val$hoverHandlesGeometryInSceneProvider;
            {
                this.val$hoverHandlesGeometryInSceneProvider = provider;
            }

            public BezierCurve[] get() {
                IGeometry handleGeometry = (IGeometry)this.val$hoverHandlesGeometryInSceneProvider.get();
                if (handleGeometry instanceof IShape) {
                    ArrayList<BezierCurve> segments = new ArrayList<BezierCurve>();
                    ICurve[] iCurveArray = ((IShape)handleGeometry).getOutlineSegments();
                    int n = iCurveArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICurve os = iCurveArray[n2];
                        segments.addAll(Arrays.asList(os.toBezier()));
                        ++n2;
                    }
                    return segments.toArray(new BezierCurve[0]);
                }
                if (handleGeometry instanceof ICurve) {
                    return ((ICurve)handleGeometry).toBezier();
                }
                throw new IllegalStateException("Unable to determine handle position: Expected IShape or ICurve but got: " + handleGeometry);
            }
        };
        BezierCurve[] segments = (BezierCurve[])hoverHandlesSegmentsInSceneProvider.get();
        int i = 0;
        while (i < segments.length) {
            IHandlePart<Node, ? extends Node> hp = this.createHoverSegmentHandlePart(target, hoverHandlesSegmentsInSceneProvider, segments.length, i, contextMap);
            if (hp != null) {
                handleParts.add(hp);
            }
            ++i;
        }
        return handleParts;
    }

    protected IHandlePart<Node, ? extends Node> createHoverSegmentHandlePart(IVisualPart<Node, ? extends Node> target, Provider<BezierCurve[]> hoverHandlesSegmentsInSceneProvider, int segmentCount, int segmentIndex, Map<Object, Object> contextMap) {
        FXCircleSegmentHandlePart part = new FXCircleSegmentHandlePart(hoverHandlesSegmentsInSceneProvider, segmentIndex, 0.0);
        this.injector.injectMembers((Object)part);
        return part;
    }

    protected List<IHandlePart<Node, ? extends Node>> createMultiSelectionHandleParts(final List<? extends IVisualPart<Node, ? extends Node>> targets, Map<Object, Object> contextMap) {
        Provider<IGeometry> handleGeometryProvider = new Provider<IGeometry>(){

            public IGeometry get() {
                return FXPartUtils.getUnionedVisualBoundsInScene(targets);
            }
        };
        return this.createBoundsSelectionHandleParts(targets, (Provider<? extends IGeometry>)handleGeometryProvider, contextMap);
    }

    private Provider<BezierCurve[]> createSegmentsProvider(final Provider<? extends IGeometry> geometryProvider) {
        return new Provider<BezierCurve[]>(){

            public BezierCurve[] get() {
                IGeometry geometry = (IGeometry)geometryProvider.get();
                if (geometry instanceof IShape) {
                    ArrayList<BezierCurve> segments = new ArrayList<BezierCurve>();
                    ICurve[] iCurveArray = ((IShape)geometry).getOutlineSegments();
                    int n = iCurveArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICurve os = iCurveArray[n2];
                        segments.addAll(Arrays.asList(os.toBezier()));
                        ++n2;
                    }
                    return segments.toArray(new BezierCurve[0]);
                }
                if (geometry instanceof ICurve) {
                    return ((ICurve)geometry).toBezier();
                }
                throw new IllegalStateException("Unable to deduce segments from geometry: Expected IShape or ICurve but got: " + geometry);
            }
        };
    }

    protected List<IHandlePart<Node, ? extends Node>> createSelectionHandleParts(List<? extends IVisualPart<Node, ? extends Node>> targets, SelectionBehavior<Node> selectionBehavior, Map<Object, Object> contextMap) {
        if (targets.isEmpty()) {
            return Collections.emptyList();
        }
        if (targets.size() == 1) {
            return this.createSingleSelectionHandleParts(targets.get(0), contextMap);
        }
        return this.createMultiSelectionHandleParts(targets, contextMap);
    }

    protected IHandlePart<Node, ? extends Node> createSelectionSegmentHandlePart(IVisualPart<Node, ? extends Node> target, Provider<BezierCurve[]> segmentsProvider, int segmentCount, int segmentIndex, Map<Object, Object> contextMap) {
        FXCircleSegmentHandlePart part = new FXCircleSegmentHandlePart(segmentsProvider, segmentIndex, 0.0);
        this.injector.injectMembers((Object)part);
        return part;
    }

    protected List<IHandlePart<Node, ? extends Node>> createSingleSelectionHandleParts(final IVisualPart<Node, ? extends Node> target, Map<Object, Object> contextMap) {
        IGeometry selectionHandlesGeometry;
        ArrayList<IHandlePart<Node, ? extends Node>> handleParts = new ArrayList<IHandlePart<Node, ? extends Node>>();
        final Provider selectionHandlesGeometryInTargetLocalProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_HANDLES_GEOMETRY_PROVIDER));
        IGeometry iGeometry = selectionHandlesGeometry = selectionHandlesGeometryInTargetLocalProvider != null ? (IGeometry)selectionHandlesGeometryInTargetLocalProvider.get() : null;
        if (selectionHandlesGeometry == null) {
            return handleParts;
        }
        Provider<IGeometry> selectionHandlesGeometryInSceneProvider = new Provider<IGeometry>(){

            public IGeometry get() {
                return FXUtils.localToScene((Node)((Node)target.getVisual()), (IGeometry)((IGeometry)selectionHandlesGeometryInTargetLocalProvider.get()));
            }
        };
        Provider<BezierCurve[]> selectionHandlesSegmentsInSceneProvider = this.createSegmentsProvider((Provider<? extends IGeometry>)selectionHandlesGeometryInSceneProvider);
        if (selectionHandlesGeometry instanceof ICurve) {
            handleParts.addAll(this.createCurveSelectionHandleParts(target, selectionHandlesSegmentsInSceneProvider, contextMap));
        } else if (selectionHandlesGeometry instanceof IShape) {
            if (selectionHandlesGeometry instanceof Rectangle) {
                handleParts.addAll(this.createTightBoundsSelectionHandleParts(Collections.singletonList(target), selectionHandlesSegmentsInSceneProvider, contextMap));
            } else {
                BezierCurve[] segments = (BezierCurve[])selectionHandlesSegmentsInSceneProvider.get();
                int i = 0;
                while (i < segments.length) {
                    IHandlePart<Node, ? extends Node> hp = this.createSelectionSegmentHandlePart(target, selectionHandlesSegmentsInSceneProvider, segments.length, i, contextMap);
                    if (hp != null) {
                        handleParts.add(hp);
                    }
                    ++i;
                }
            }
        } else {
            throw new IllegalStateException("Unable to generate handles for this handle geometry. Expected ICurve or IShape, but got: " + selectionHandlesGeometry);
        }
        return handleParts;
    }

    protected Collection<? extends IHandlePart<Node, ? extends Node>> createTightBoundsSelectionHandleParts(List<? extends IVisualPart<Node, ? extends Node>> targetParts, Provider<BezierCurve[]> segmentsProvider, Map<Object, Object> contextMap) {
        ArrayList<FXRectangleSegmentHandlePart> hps = new ArrayList<FXRectangleSegmentHandlePart>();
        BezierCurve[] segments = (BezierCurve[])segmentsProvider.get();
        int i = 0;
        while (i < segments.length) {
            FXRectangleSegmentHandlePart part = new FXRectangleSegmentHandlePart(segmentsProvider, i, 0.0);
            this.injector.injectMembers((Object)part);
            hps.add(part);
            ++i;
        }
        return hps;
    }
}

