/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.inject.Provider;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef4.fx.nodes.FXGeometryNode;
import org.eclipse.gef4.fx.nodes.FXUtils;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXFeedbackPart;

public class FXHoverFeedbackPart
extends AbstractFXFeedbackPart<FXGeometryNode<IGeometry>> {
    public static final Color DEFAULT_STROKE = Color.web((String)"#5a61af");
    private final Provider<? extends IGeometry> feedbackGeometryProvider;

    public FXHoverFeedbackPart(Provider<? extends IGeometry> feedbackGeometryProvider) {
        this.feedbackGeometryProvider = feedbackGeometryProvider;
    }

    protected FXGeometryNode<IGeometry> createVisual() {
        FXGeometryNode visual = new FXGeometryNode();
        visual.setFill((Paint)Color.TRANSPARENT);
        visual.setMouseTransparent(true);
        visual.setManaged(false);
        visual.setStrokeType(StrokeType.OUTSIDE);
        visual.setStrokeWidth(1.0);
        visual.setEffect(this.getHoverFeedbackEffect());
        visual.setStroke((Paint)DEFAULT_STROKE);
        return visual;
    }

    public void doRefreshVisual(FXGeometryNode<IGeometry> visual) {
        if (this.getAnchorages().size() != 1) {
            return;
        }
        IGeometry feedbackGeometry = this.getFeedbackGeometry();
        if (feedbackGeometry == null) {
            return;
        }
        visual.setGeometry(feedbackGeometry);
        if (feedbackGeometry instanceof ICurve) {
            visual.setStrokeType(StrokeType.CENTERED);
        } else {
            visual.setStrokeType(StrokeType.OUTSIDE);
        }
    }

    protected IGeometry getFeedbackGeometry() {
        return FXUtils.sceneToLocal((Node)((Node)this.getVisual()), (IGeometry)((IGeometry)this.feedbackGeometryProvider.get()));
    }

    public Effect getHoverFeedbackEffect() {
        DropShadow effect = new DropShadow();
        effect.setRadius(3.0);
        return effect;
    }
}

