/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.inject.Provider;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.fx.nodes.FXConnection;
import org.eclipse.gef4.fx.nodes.FXGeometryNode;
import org.eclipse.gef4.fx.nodes.FXUtils;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class VisualOutlineGeometryProvider
implements IAdaptable.Bound<IVisualPart<Node, ? extends Node>>,
Provider<IGeometry> {
    private IVisualPart<Node, ? extends Node> host;

    public IGeometry get() {
        return this.getGeometry((Node)this.host.getVisual());
    }

    public IVisualPart<Node, ? extends Node> getAdaptable() {
        return this.host;
    }

    protected IGeometry getGeometry(Node visual) {
        if (visual instanceof FXConnection) {
            FXGeometryNode curveNode = ((FXConnection)visual).getCurveNode();
            if (curveNode instanceof FXGeometryNode) {
                return FXUtils.localToParent((Node)curveNode, (IGeometry)curveNode.getGeometry());
            }
        } else if (visual instanceof FXGeometryNode) {
            return ((FXGeometryNode)visual).getGeometry();
        }
        return JavaFX2Geometry.toRectangle((Bounds)visual.getLayoutBounds());
    }

    public void setAdaptable(IVisualPart<Node, ? extends Node> adaptable) {
        this.host = adaptable;
    }
}

