/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.fx.anchors.FXStaticAnchor;
import org.eclipse.gef4.fx.anchors.IFXAnchor;
import org.eclipse.gef4.fx.nodes.FXConnection;
import org.eclipse.gef4.fx.nodes.FXUtils;
import org.eclipse.gef4.geometry.convert.fx.Geometry2JavaFX;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.operations.FXBendOperation;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.ChangeSelectionOperation;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactional;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.SetRefreshVisualOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractPolicy;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXBendPolicy
extends AbstractPolicy<Node>
implements ITransactional {
    protected static final double DEFAULT_OVERLAY_THRESHOLD = 10.0;
    private IFXAnchor removedOverlainAnchor;
    private int removedOverlainAnchorIndex;
    private int currentAnchorIndex;
    private int currentAnchorIndexBeforeOverlaidRemoval;
    private FXBendOperation op;
    private Point initialMousePositionInScene;
    private Point initialReferencePositionInLocal;

    protected boolean canAttach() {
        return this.currentAnchorIndex == 0 || this.currentAnchorIndex == this.op.getNewAnchors().size() - 1;
    }

    public IUndoableOperation commit() {
        if (this.op != null) {
            IViewer viewer = this.getHost().getRoot().getViewer();
            SelectionModel selectionModel = (SelectionModel)viewer.getAdapter(SelectionModel.class);
            List selection = selectionModel.getSelected();
            ArrayList selectionWithoutHost = new ArrayList(selectionModel.getSelected());
            selectionWithoutHost.remove(this.getHost());
            ChangeSelectionOperation deselectOperation = new ChangeSelectionOperation(viewer, selection, selectionWithoutHost);
            ChangeSelectionOperation selectOperation = new ChangeSelectionOperation(viewer, selectionWithoutHost, selection);
            ReverseUndoCompositeOperation reselectOperation = new ReverseUndoCompositeOperation("re-select");
            reselectOperation.add((IUndoableOperation)deselectOperation);
            reselectOperation.add((IUndoableOperation)selectOperation);
            ForwardUndoCompositeOperation updateOperation = new ForwardUndoCompositeOperation(this.op.getLabel());
            updateOperation.add((IUndoableOperation)this.op);
            updateOperation.add((IUndoableOperation)reselectOperation);
            ReverseUndoCompositeOperation guardedUpdateOperation = new ReverseUndoCompositeOperation(this.op.getLabel());
            guardedUpdateOperation.add((IUndoableOperation)new SetRefreshVisualOperation(this.getHost(), this.getHost().isRefreshVisual(), false));
            guardedUpdateOperation.add((IUndoableOperation)updateOperation);
            guardedUpdateOperation.add((IUndoableOperation)new SetRefreshVisualOperation(this.getHost(), false, this.getHost().isRefreshVisual()));
            return guardedUpdateOperation;
        }
        return this.op;
    }

    public void createAndSelectSegmentPoint(int segmentIndex, Point mouseInScene) {
        this.op.getNewAnchors().add(segmentIndex + 1, (IFXAnchor)new FXStaticAnchor(mouseInScene));
        this.locallyExecuteOperation();
        this.selectSegmentPoint(segmentIndex + 1, 0.0, mouseInScene);
    }

    protected IFXAnchor findAnchor(Point currentReferencePositionInScene, boolean canAttach) {
        List pickedNodes;
        IContentPart<Node, ? extends Node> anchorPart;
        FXStaticAnchor anchor = null;
        if (canAttach && (anchorPart = this.getAnchorPart(this.getParts(pickedNodes = FXUtils.getNodesAt((Node)((Node)this.getHost().getRoot().getVisual()), (double)currentReferencePositionInScene.x, (double)currentReferencePositionInScene.y)))) != null) {
            anchor = (IFXAnchor)((Provider)anchorPart.getAdapter((TypeToken)new TypeToken<Provider<? extends IFXAnchor>>(){})).get();
        }
        if (anchor == null) {
            anchor = new FXStaticAnchor(currentReferencePositionInScene);
        }
        return anchor;
    }

    private IContentPart<Node, ? extends Node> getAnchorPart(List<IContentPart<Node, ? extends Node>> partsUnderMouse) {
        for (IContentPart<Node, ? extends Node> cp : partsUnderMouse) {
            IContentPart<Node, ? extends Node> part = cp;
            Provider anchorProvider = (Provider)part.getAdapter((TypeToken)new TypeToken<Provider<? extends IFXAnchor>>(){});
            if (anchorProvider == null || anchorProvider.get() == null) continue;
            return part;
        }
        return null;
    }

    protected FXConnection getConnection() {
        return (FXConnection)this.getHost().getVisual();
    }

    protected Point getInitialMousePositionInScene() {
        return this.initialMousePositionInScene;
    }

    protected Point getInitialReferencePositionInLocal() {
        return this.initialReferencePositionInLocal;
    }

    protected double getOverlayThreshold() {
        GridModel model = (GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class);
        if (model != null && model.isSnapToGrid()) {
            return Math.min(model.getGridCellWidth(), model.getGridCellHeight()) / 4.0;
        }
        return 10.0;
    }

    private List<IContentPart<Node, ? extends Node>> getParts(List<Node> nodesUnderMouse) {
        ArrayList<IContentPart<Node, ? extends Node>> parts = new ArrayList<IContentPart<Node, ? extends Node>>();
        Map partMap = this.getHost().getRoot().getViewer().getVisualPartMap();
        for (Node node : nodesUnderMouse) {
            IVisualPart part;
            if (!partMap.containsKey(node) || !((part = (IVisualPart)partMap.get(node)) instanceof IContentPart)) continue;
            parts.add((IContentPart<Node, ? extends Node>)((IContentPart)part));
        }
        return parts;
    }

    protected void hideShowOverlain(Point currentPositionInScene) {
        int candidateIndex;
        if (this.removedOverlainAnchor != null) {
            this.currentAnchorIndex = this.currentAnchorIndexBeforeOverlaidRemoval;
            this.op.getNewAnchors().add(this.removedOverlainAnchorIndex, this.removedOverlainAnchor);
            this.locallyExecuteOperation();
            this.removedOverlainAnchor = null;
        }
        if (this.op.getNewAnchors().size() <= 2) {
            return;
        }
        this.removedOverlainAnchorIndex = -1;
        this.currentAnchorIndexBeforeOverlaidRemoval = this.currentAnchorIndex;
        if (this.currentAnchorIndex > 0 && this.isOverlain(candidateIndex = this.currentAnchorIndex - 1, this.currentAnchorIndex, currentPositionInScene)) {
            this.removedOverlainAnchorIndex = candidateIndex;
            --this.currentAnchorIndex;
        }
        if (this.removedOverlainAnchorIndex == -1 && this.currentAnchorIndex < this.op.getNewAnchors().size() - 1 && this.isOverlain(candidateIndex = this.currentAnchorIndex + 1, this.currentAnchorIndex, currentPositionInScene)) {
            this.removedOverlainAnchorIndex = candidateIndex;
        }
        if (this.removedOverlainAnchorIndex != -1) {
            this.removedOverlainAnchor = this.op.getNewAnchors().remove(this.removedOverlainAnchorIndex);
            this.locallyExecuteOperation();
        }
    }

    public void init() {
        this.op = new FXBendOperation(this.getConnection());
        this.removedOverlainAnchor = null;
    }

    protected boolean isOverlain(int candidateIndex, int currentIndex, Point currentReferencePositionInScene) {
        boolean overlay;
        Point candidateLocation = null;
        candidateLocation = candidateIndex == 0 ? this.op.getConnection().getStartPoint() : (candidateIndex == this.op.getConnection().getWayAnchorsSize() + 1 ? this.op.getConnection().getEndPoint() : this.op.getConnection().getWayPoint(candidateIndex - 1));
        IFXAnchor candidateAnchor = this.findAnchor(currentReferencePositionInScene, true);
        Point currentPoint = JavaFX2Geometry.toPoint((Point2D)this.getConnection().getCurveNode().sceneToLocal(currentReferencePositionInScene.x, currentReferencePositionInScene.y));
        boolean bl = overlay = candidateLocation.getDistance(currentPoint) < this.getOverlayThreshold() && ((IFXAnchor)this.op.getConnection().getAnchors().get(candidateIndex)).getAnchorage() == candidateAnchor.getAnchorage();
        if (overlay) {
            this.op.getNewAnchors().set(currentIndex, candidateAnchor);
            this.locallyExecuteOperation();
        }
        return overlay;
    }

    protected void locallyExecuteOperation() {
        try {
            this.op.execute(null, null);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public void moveSelectedSegmentPoint(Point mouseInScene) {
        Point mouseInLocal = JavaFX2Geometry.toPoint((Point2D)this.getConnection().sceneToLocal(Geometry2JavaFX.toFXPoint((Point)mouseInScene)));
        Point deltaInLocal = mouseInLocal.getTranslated(JavaFX2Geometry.toPoint((Point2D)this.getConnection().sceneToLocal(Geometry2JavaFX.toFXPoint((Point)this.initialMousePositionInScene))).getNegated());
        Point currentReferencePositionInLocal = this.initialReferencePositionInLocal.getTranslated(deltaInLocal);
        Dimension snapToGridOffset = FXTransformPolicy.getSnapToGridOffset((GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class), currentReferencePositionInLocal.x, currentReferencePositionInLocal.y, 0.5, 0.5);
        Point currentReferencePositionInScene = JavaFX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2JavaFX.toFXPoint((Point)currentReferencePositionInLocal.getTranslated(snapToGridOffset.getNegated()))));
        this.op.getNewAnchors().set(this.currentAnchorIndex, this.findAnchor(currentReferencePositionInScene, this.canAttach()));
        this.locallyExecuteOperation();
        this.hideShowOverlain(currentReferencePositionInScene);
    }

    public void selectSegmentPoint(int segmentIndex, double segmentParameter, Point mouseInScene) {
        this.currentAnchorIndex = segmentParameter == 1.0 ? segmentIndex + 1 : segmentIndex;
        this.initialMousePositionInScene = mouseInScene.getCopy();
        this.initialReferencePositionInLocal = this.op.getConnection().getPoints()[this.currentAnchorIndex];
    }

    public String toString() {
        return "FXBendPolicy[host=" + this.getHost() + "]";
    }
}

