/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnDragPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXScaleRelocatePolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.policies.IPolicy;

public class FXScaleRelocateOnHandleDragPolicy
extends AbstractFXOnDragPolicy {
    private Point initialMouseLocation = null;
    private Rectangle selectionBounds;
    private Map<IContentPart<Node, ? extends Node>, Double> relX1 = null;
    private Map<IContentPart<Node, ? extends Node>, Double> relY1 = null;
    private Map<IContentPart<Node, ? extends Node>, Double> relX2 = null;
    private Map<IContentPart<Node, ? extends Node>, Double> relY2 = null;
    private boolean invalidGesture = false;

    private void computeRelatives(IContentPart<Node, ? extends Node> targetPart) {
        Rectangle bounds = this.getVisualBounds(targetPart);
        double left = bounds.getX() - this.selectionBounds.getX();
        this.relX1.put(targetPart, left / this.selectionBounds.getWidth());
        double right = left + bounds.getWidth();
        this.relX2.put(targetPart, right / this.selectionBounds.getWidth());
        double top = bounds.getY() - this.selectionBounds.getY();
        this.relY1.put(targetPart, top / this.selectionBounds.getHeight());
        double bottom = top + bounds.getHeight();
        this.relY2.put(targetPart, bottom / this.selectionBounds.getHeight());
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        if (this.selectionBounds == null) {
            return;
        }
        Rectangle sel = this.updateSelectionBounds(e);
        for (IContentPart<Node, ? extends Node> targetPart : this.getTargetParts()) {
            FXScaleRelocatePolicy policy = this.getScaleRelocatePolicy(targetPart);
            if (policy == null) continue;
            Bounds initialBounds = this.getBounds(this.selectionBounds, targetPart);
            Bounds newBounds = this.getBounds(sel, targetPart);
            policy.performScaleRelocate(initialBounds, newBounds);
        }
    }

    private Bounds getBounds(Rectangle sel, IContentPart<Node, ? extends Node> targetPart) {
        double x1 = sel.getX() + sel.getWidth() * this.relX1.get(targetPart);
        double x2 = sel.getX() + sel.getWidth() * this.relX2.get(targetPart);
        double y1 = sel.getY() + sel.getHeight() * this.relY1.get(targetPart);
        double y2 = sel.getY() + sel.getHeight() * this.relY2.get(targetPart);
        return new BoundingBox(x1, y1, x2 - x1, y2 - y1);
    }

    public AbstractFXSegmentHandlePart<Node> getHost() {
        return (AbstractFXSegmentHandlePart)super.getHost();
    }

    protected FXScaleRelocatePolicy getScaleRelocatePolicy(IContentPart<Node, ? extends Node> part) {
        return (FXScaleRelocatePolicy)((Object)part.getAdapter(FXScaleRelocatePolicy.class));
    }

    private Rectangle getSelectionBounds(List<IContentPart<Node, ? extends Node>> targetParts) {
        if (targetParts.isEmpty()) {
            throw new IllegalArgumentException("No target parts given.");
        }
        Rectangle bounds = this.getVisualBounds(targetParts.get(0));
        if (targetParts.size() == 1) {
            return bounds;
        }
        ListIterator<IContentPart<Node, ? extends Node>> iterator = targetParts.listIterator(1);
        while (iterator.hasNext()) {
            IContentPart<Node, ? extends Node> cp = iterator.next();
            bounds.union(this.getVisualBounds(cp));
        }
        return bounds;
    }

    public List<IContentPart<Node, ? extends Node>> getTargetParts() {
        return ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class)).getSelected();
    }

    protected Rectangle getVisualBounds(IContentPart<Node, ? extends Node> contentPart) {
        if (contentPart == null) {
            throw new IllegalArgumentException("contentPart may not be null!");
        }
        return JavaFX2Geometry.toRectangle((Bounds)((Node)contentPart.getVisual()).localToScene(((Node)contentPart.getVisual()).getLayoutBounds()));
    }

    @Override
    public void press(MouseEvent e) {
        List<IContentPart<Node, ? extends Node>> targetParts = this.getTargetParts();
        if (targetParts.size() < 2 || e.isControlDown()) {
            this.invalidGesture = true;
            return;
        }
        this.initialMouseLocation = new Point(e.getSceneX(), e.getSceneY());
        this.selectionBounds = this.getSelectionBounds(targetParts);
        this.relX1 = new HashMap<IContentPart<Node, ? extends Node>, Double>();
        this.relY1 = new HashMap<IContentPart<Node, ? extends Node>, Double>();
        this.relX2 = new HashMap<IContentPart<Node, ? extends Node>, Double>();
        this.relY2 = new HashMap<IContentPart<Node, ? extends Node>, Double>();
        for (IContentPart<Node, ? extends Node> targetPart : targetParts) {
            FXScaleRelocatePolicy policy = this.getScaleRelocatePolicy(targetPart);
            if (policy == null) continue;
            this.computeRelatives(targetPart);
            this.init((IPolicy)policy);
        }
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            this.invalidGesture = false;
            return;
        }
        for (IContentPart<Node, ? extends Node> part : this.getTargetParts()) {
            FXScaleRelocatePolicy policy = this.getScaleRelocatePolicy(part);
            if (policy == null) continue;
            this.commit((IPolicy)policy);
        }
        this.selectionBounds = null;
        this.initialMouseLocation = null;
        this.relY2 = null;
        this.relX2 = null;
        this.relY1 = null;
        this.relX1 = null;
    }

    private Rectangle updateSelectionBounds(MouseEvent e) {
        Rectangle sel = this.selectionBounds.getCopy();
        double dx = e.getSceneX() - this.initialMouseLocation.x;
        double dy = e.getSceneY() - this.initialMouseLocation.y;
        int segment = this.getHost().getSegmentIndex();
        if (segment == 0 || segment == 3) {
            sel.shrink(dx, 0.0, 0.0, 0.0);
        } else if (segment == 1 || segment == 2) {
            sel.expand(0.0, 0.0, dx, 0.0);
        }
        if (segment == 0 || segment == 1) {
            sel.shrink(0.0, dy, 0.0, 0.0);
        } else if (segment == 2 || segment == 3) {
            sel.expand(0.0, 0.0, 0.0, dy);
        }
        return sel;
    }
}

