/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.geometry.convert.fx.Geometry2JavaFX;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.fx.operations.FXTransformOperation;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.operations.ITransactional;
import org.eclipse.gef4.mvc.policies.AbstractPolicy;

public class FXTransformPolicy
extends AbstractPolicy<Node>
implements ITransactional {
    public static final String TRANSFORMATION_PROVIDER_ROLE = "transformationProvider";
    private FXTransformOperation transformOperation;
    private AffineTransform oldTransform;
    private Affine nodeTransform;

    protected static Dimension getSnapToGridOffset(GridModel gridModel, double localX, double localY, double gridCellWidthFraction, double gridCellHeightFraction) {
        double snapOffsetX = 0.0;
        double snapOffsetY = 0.0;
        if (gridModel != null && gridModel.isSnapToGrid()) {
            double snapWidth = gridModel.getGridCellWidth() * gridCellWidthFraction;
            double snapHeight = gridModel.getGridCellHeight() * gridCellHeightFraction;
            snapOffsetX = localX % snapWidth;
            if (snapOffsetX > snapWidth / 2.0) {
                snapOffsetX = snapWidth - snapOffsetX;
                snapOffsetX *= -1.0;
            }
            if ((snapOffsetY = localY % snapHeight) > snapHeight / 2.0) {
                snapOffsetY = snapHeight - snapOffsetY;
                snapOffsetY *= -1.0;
            }
        }
        return new Dimension(snapOffsetX, snapOffsetY);
    }

    public IUndoableOperation commit() {
        FXTransformOperation commit = this.transformOperation;
        this.transformOperation = null;
        this.oldTransform = null;
        return commit;
    }

    public Affine getNodeTransform() {
        if (this.nodeTransform == null) {
            this.nodeTransform = (Affine)((Provider)this.getHost().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Affine>>(){}, (String)TRANSFORMATION_PROVIDER_ROLE))).get();
        }
        return this.nodeTransform;
    }

    public void init() {
        this.transformOperation = new FXTransformOperation(this.getNodeTransform());
        this.oldTransform = JavaFX2Geometry.toAffineTransform((Transform)this.transformOperation.getOldTransform());
    }

    public void setConcatenation(AffineTransform transform) {
        this.setTransform(this.oldTransform.getCopy().concatenate(transform));
    }

    public void setPreConcatenation(AffineTransform transform) {
        this.setTransform(this.oldTransform.getCopy().preConcatenate(transform));
    }

    public void setTransform(AffineTransform newTransform) {
        Dimension snapToGridOffset = FXTransformPolicy.getSnapToGridOffset((GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class), newTransform.getTranslateX(), newTransform.getTranslateY(), 0.5, 0.5);
        newTransform.setTransform(newTransform.getM00(), newTransform.getM10(), newTransform.getM01(), newTransform.getM11(), newTransform.getTranslateX() - snapToGridOffset.width, newTransform.getTranslateY() - snapToGridOffset.height);
        this.transformOperation.setNewTransform(Geometry2JavaFX.toFXAffine((AffineTransform)newTransform));
        try {
            this.transformOperation.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

