/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.input.RotateEvent;
import org.eclipse.gef4.fx.gestures.FXRotateGesture;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnRotatePolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXRotateTool
extends AbstractTool<Node> {
    public static final Class<AbstractFXOnRotatePolicy> TOOL_POLICY_KEY = AbstractFXOnRotatePolicy.class;
    private final Map<IViewer<Node>, FXRotateGesture> gestures = new HashMap<IViewer<Node>, FXRotateGesture>();

    protected Set<? extends AbstractFXOnRotatePolicy> getRotatePolicies(IVisualPart<Node, ? extends Node> targetPart) {
        return new HashSet(targetPart.getAdapters(TOOL_POLICY_KEY).values());
    }

    protected Set<? extends AbstractFXOnRotatePolicy> getTargetPolicies(IViewer<Node> viewer, RotateEvent e) {
        EventTarget target = e.getTarget();
        if (!(target instanceof Node)) {
            return null;
        }
        Node targetNode = (Node)target;
        IRootPart targetPart = FXPartUtils.getTargetPart(Collections.singleton(viewer), targetNode, TOOL_POLICY_KEY, true);
        if (targetPart == null) {
            targetPart = viewer.getRootPart();
        }
        return this.getRotatePolicies((IVisualPart<Node, ? extends Node>)targetPart);
    }

    protected void registerListeners() {
        super.registerListeners();
        for (final IViewer viewer : this.getDomain().getViewers().values()) {
            FXRotateGesture gesture = new FXRotateGesture(){

                protected void rotate(RotateEvent event) {
                    for (AbstractFXOnRotatePolicy abstractFXOnRotatePolicy : FXRotateTool.this.getTargetPolicies((IViewer<Node>)viewer, event)) {
                        abstractFXOnRotatePolicy.rotate(event);
                    }
                }

                protected void rotationFinished(RotateEvent event) {
                    for (AbstractFXOnRotatePolicy abstractFXOnRotatePolicy : FXRotateTool.this.getTargetPolicies((IViewer<Node>)viewer, event)) {
                        abstractFXOnRotatePolicy.rotationFinished(event);
                    }
                }

                protected void rotationStarted(RotateEvent event) {
                    for (AbstractFXOnRotatePolicy abstractFXOnRotatePolicy : FXRotateTool.this.getTargetPolicies((IViewer<Node>)viewer, event)) {
                        abstractFXOnRotatePolicy.rotationStarted(event);
                    }
                }
            };
            gesture.setScene(((FXViewer)viewer).getScene());
            this.gestures.put((IViewer<Node>)viewer, gesture);
        }
    }

    protected void unregisterListeners() {
        for (FXRotateGesture gesture : this.gestures.values()) {
            gesture.setScene(null);
        }
        super.unregisterListeners();
    }
}

