/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.viewer;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.eclipse.gef4.fx.nodes.FXGridLayer;
import org.eclipse.gef4.fx.nodes.ScrollPaneEx;
import org.eclipse.gef4.mvc.fx.domain.FXDomain;
import org.eclipse.gef4.mvc.fx.viewer.ISceneContainer;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.AbstractViewer;

public class FXViewer
extends AbstractViewer<Node> {
    private static final String SCROLL_PANE_STYLE = "-fx-background-insets:0;-fx-padding:0;-fx-background-color:rgba(0,0,0,0);";
    protected ISceneContainer sceneContainer;
    protected Scene scene = null;
    protected ScrollPaneEx scrollPane;
    protected FXGridLayer gridLayer;

    protected void createAndHookScene(ISceneContainer container, Parent rootVisual) {
        this.scrollPane = new ScrollPaneEx();
        this.scrollPane.setStyle(SCROLL_PANE_STYLE);
        this.gridLayer = new FXGridLayer();
        this.scrollPane.getContentGroup().getChildren().addAll((Object[])new Node[]{rootVisual});
        this.scrollPane.getScrolledPane().getChildren().add((Object)this.gridLayer);
        this.gridLayer.toBack();
        SimpleObjectProperty<Bounds> scrollableBoundsProperty = new SimpleObjectProperty<Bounds>(){
            {
                this.bind((ObservableValue)FXViewer.this.scrollPane.getScrollableBoundsBinding());
            }
        };
        this.gridLayer.bindMinSizeToBounds((ReadOnlyObjectProperty)scrollableBoundsProperty);
        this.gridLayer.bindPrefSizeToUnionedBounds(new ReadOnlyObjectProperty[]{scrollableBoundsProperty});
        this.scene = new Scene((Parent)this.scrollPane);
        this.sceneContainer.setScene(this.scene);
    }

    public FXDomain getDomain() {
        return (FXDomain)super.getDomain();
    }

    public FXGridLayer getGridLayer() {
        return this.gridLayer;
    }

    public Scene getScene() {
        return this.scene;
    }

    public ScrollPaneEx getScrollPane() {
        return this.scrollPane;
    }

    public void reveal(IVisualPart<Node, ? extends Node> visualPart) {
        this.scrollPane.reveal((Node)visualPart.getVisual());
    }

    public void setSceneContainer(ISceneContainer sceneContainer) {
        this.sceneContainer = sceneContainer;
        if (sceneContainer != null) {
            if (this.scene == null) {
                IRootPart rootPart = this.getRootPart();
                if (rootPart != null) {
                    this.createAndHookScene(sceneContainer, (Parent)rootPart.getVisual());
                }
            } else {
                sceneContainer.setScene(this.scene);
            }
        }
    }
}

