/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.behaviors;

import com.google.inject.Inject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.common.inject.AdaptableScopes;
import org.eclipse.gef4.mvc.behaviors.BehaviorUtils;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPartFactory;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IHandlePartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractBehavior<VR>
implements IBehavior<VR> {
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @Inject
    private IFeedbackPartFactory<VR> feedbackPartFactory;
    @Inject
    private IHandlePartFactory<VR> handlePartFactory;
    private IVisualPart<VR, ? extends VR> host;
    private boolean active;
    private List<IHandlePart<VR, ? extends VR>> handleParts;
    private List<IFeedbackPart<VR, ? extends VR>> feedbackParts;

    public void activate() {
        boolean oldActive = this.active;
        this.active = true;
        if (oldActive != this.active) {
            this.pcs.firePropertyChange("active", oldActive, this.active);
        }
    }

    protected void addFeedback(List<? extends IVisualPart<VR, ? extends VR>> targets) {
        this.addFeedback(targets, Collections.<Object, Object>emptyMap());
    }

    protected void addFeedback(List<? extends IVisualPart<VR, ? extends VR>> targets, Map<Object, Object> contextMap) {
        if (targets != null && !targets.isEmpty()) {
            this.switchAdaptableScopes();
            this.feedbackParts = this.feedbackPartFactory.createFeedbackParts(targets, this, contextMap);
            BehaviorUtils.addAnchorages(this.getHost().getRoot(), targets, this.feedbackParts);
        }
    }

    protected void addHandles(List<? extends IVisualPart<VR, ? extends VR>> targets) {
        this.addHandles(targets, Collections.<Object, Object>emptyMap());
    }

    protected void addHandles(List<? extends IVisualPart<VR, ? extends VR>> targets, Map<Object, Object> contextMap) {
        if (targets != null && !targets.isEmpty()) {
            this.switchAdaptableScopes();
            this.handleParts = this.handlePartFactory.createHandleParts(targets, this, contextMap);
            BehaviorUtils.addAnchorages(this.getHost().getRoot(), targets, this.handleParts);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void deactivate() {
        boolean oldActive = this.active;
        this.active = false;
        if (oldActive != this.active) {
            this.pcs.firePropertyChange("active", oldActive, this.active);
        }
    }

    public IVisualPart<VR, ? extends VR> getAdaptable() {
        return this.getHost();
    }

    protected List<IFeedbackPart<VR, ? extends VR>> getFeedbackParts() {
        return this.feedbackParts;
    }

    protected List<IHandlePart<VR, ? extends VR>> getHandleParts() {
        return this.handleParts;
    }

    @Override
    public IVisualPart<VR, ? extends VR> getHost() {
        return this.host;
    }

    public boolean isActive() {
        return this.active;
    }

    protected void removeFeedback(List<? extends IVisualPart<VR, ? extends VR>> targets) {
        if (this.feedbackParts != null && !this.feedbackParts.isEmpty() && targets != null && !targets.isEmpty()) {
            BehaviorUtils.removeAnchorages(this.getHost().getRoot(), targets, this.feedbackParts);
            this.feedbackParts.clear();
        }
    }

    protected void removeHandles(List<? extends IVisualPart<VR, ? extends VR>> targets) {
        if (this.handleParts != null && !this.handleParts.isEmpty() && targets != null && !targets.isEmpty()) {
            BehaviorUtils.removeAnchorages(this.getHost().getRoot(), targets, this.handleParts);
            this.handleParts.clear();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setAdaptable(IVisualPart<VR, ? extends VR> adaptable) {
        this.host = adaptable;
    }

    protected void switchAdaptableScopes() {
        IVisualPart<VR, VR> host = this.getHost();
        IViewer<VR> viewer = host.getRoot().getViewer();
        IDomain<VR> domain = viewer.getDomain();
        AdaptableScopes.switchTo(domain);
        AdaptableScopes.switchTo(viewer);
        AdaptableScopes.switchTo(host);
    }
}

