/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.policies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.mvc.operations.ITransactional;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.IPolicy;

public abstract class AbstractPolicy<VR>
implements IPolicy<VR> {
    private IVisualPart<VR, ? extends VR> host;
    private final Map<IVisualPart<VR, ? extends VR>, Boolean> initialRefreshVisual = new HashMap<IVisualPart<VR, ? extends VR>, Boolean>();

    protected void commit(IPolicy<VR> policy) {
        IUndoableOperation o;
        if (policy != null && policy instanceof ITransactional && (o = ((ITransactional)((Object)policy)).commit()) != null && o.canExecute()) {
            this.getHost().getRoot().getViewer().getDomain().execute(o);
        }
    }

    protected void disableRefreshVisuals(IVisualPart<VR, ? extends VR> anchorage) {
        this.initialRefreshVisual.put(anchorage, anchorage.isRefreshVisual());
    }

    protected void enableRefreshVisuals(IVisualPart<VR, ? extends VR> part) {
        part.setRefreshVisual(this.initialRefreshVisual.remove(part));
    }

    public IVisualPart<VR, ? extends VR> getAdaptable() {
        return this.getHost();
    }

    @Override
    public IVisualPart<VR, ? extends VR> getHost() {
        return this.host;
    }

    protected void init(IPolicy<VR> policy) {
        if (policy != null && policy instanceof ITransactional) {
            ((ITransactional)((Object)policy)).init();
        }
    }

    public void setAdaptable(IVisualPart<VR, ? extends VR> adaptable) {
        this.host = adaptable;
    }
}

