/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javafx.scene.Node;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.zest.fx.models.HidingModel;

public abstract class AbstractHidingBehavior
extends AbstractBehavior<Node> {
    private PropertyChangeListener hidingModelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("hidden".equals(evt.getPropertyName())) {
                AbstractHidingBehavior.this.onHidingModelChange();
            }
        }
    };
    private boolean isHidden;

    public void activate() {
        super.activate();
        HidingModel hidingModel = this.getHidingModel();
        hidingModel.addPropertyChangeListener(this.hidingModelListener);
    }

    public void deactivate() {
        HidingModel hidingModel = this.getHidingModel();
        hidingModel.removePropertyChangeListener(this.hidingModelListener);
        super.deactivate();
    }

    protected abstract boolean determineHiddenStatus();

    protected HidingModel getHidingModel() {
        return (HidingModel)this.getHost().getRoot().getViewer().getAdapter(HidingModel.class);
    }

    protected void hide() {
        ((Node)this.getHost().getVisual()).setVisible(false);
        ((Node)this.getHost().getVisual()).setMouseTransparent(true);
    }

    protected boolean isHidden() {
        return this.isHidden;
    }

    protected void onHidingModelChange() {
        boolean wasHidden = this.isHidden;
        this.isHidden = this.determineHiddenStatus();
        if (wasHidden && !this.isHidden) {
            this.show();
        } else if (!wasHidden && this.isHidden) {
            this.hide();
        }
    }

    protected void show() {
        ((Node)this.getHost().getVisual()).setVisible(true);
        ((Node)this.getHost().getVisual()).setMouseTransparent(false);
    }
}

