/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import javafx.scene.Group;
import javafx.scene.Node;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.behaviors.BehaviorUtils;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.models.HidingModel;
import org.eclipse.gef4.zest.fx.parts.HiddenNeighborsPart;
import org.eclipse.gef4.zest.fx.parts.NodeContentPart;

public class HidingBehavior
extends AbstractBehavior<Node>
implements PropertyChangeListener {
    private IVisualPart<Node, ? extends Node> hiddenNeighborsPart;
    private boolean isHidden;

    public void activate() {
        super.activate();
        HidingModel hidingModel = this.getHidingModel();
        hidingModel.addPropertyChangeListener(this);
        this.getHost().addPropertyChangeListener(this);
        this.isHidden = hidingModel.isHidden(this.getHost().getContent());
        if (this.hasHiddenNeighbors(this.getHost().getContent(), hidingModel)) {
            this.createHiddenNeighborPart();
        }
    }

    private boolean containsAny(Set<org.eclipse.gef4.graph.Node> hidden, Set<org.eclipse.gef4.graph.Node> neighbors) {
        boolean containsAny = false;
        for (org.eclipse.gef4.graph.Node n : neighbors) {
            if (!hidden.contains(n)) continue;
            containsAny = true;
            break;
        }
        return containsAny;
    }

    protected void createHiddenNeighborPart() {
        this.hiddenNeighborsPart = new HiddenNeighborsPart();
        BehaviorUtils.addAnchorages((IRootPart)this.getHost().getRoot(), Collections.singletonList(this.getHost()), Collections.singletonList(this.hiddenNeighborsPart));
    }

    public void deactivate() {
        HidingModel hidingModel = this.getHidingModel();
        if (this.hasHiddenNeighbors(this.getHost().getContent(), hidingModel)) {
            this.removeHiddenNeighborPart();
        }
        hidingModel.removePropertyChangeListener(this);
        super.deactivate();
    }

    protected HidingModel getHidingModel() {
        return (HidingModel)this.getHost().getRoot().getViewer().getAdapter(HidingModel.class);
    }

    public NodeContentPart getHost() {
        return (NodeContentPart)super.getHost();
    }

    protected IVisualPart<Node, ? extends Node> getPrunedNeighborsPart() {
        return this.hiddenNeighborsPart;
    }

    private boolean hasHiddenNeighbors(org.eclipse.gef4.graph.Node node, HidingModel hidingModel) {
        return !hidingModel.getHiddenNeighbors(node).isEmpty();
    }

    protected void hide() {
        ((Group)this.getHost().getVisual()).setVisible(false);
        ((Group)this.getHost().getVisual()).setMouseTransparent(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("hidden".equals(event.getPropertyName())) {
            boolean wasHidden = this.isHidden;
            this.isHidden = this.getHidingModel().isHidden(this.getHost().getContent());
            if (wasHidden && !this.isHidden) {
                this.show();
            } else if (!wasHidden && this.isHidden) {
                this.hide();
            }
            Set oldHidden = (Set)event.getOldValue();
            Set newHidden = (Set)event.getNewValue();
            org.eclipse.gef4.graph.Node content = this.getHost().getContent();
            Set neighbors = content.getLocalNeighbors();
            if (!this.containsAny(oldHidden, neighbors) && this.containsAny(newHidden, neighbors)) {
                this.createHiddenNeighborPart();
            } else if (this.containsAny(oldHidden, neighbors) && !this.containsAny(newHidden, neighbors)) {
                this.removeHiddenNeighborPart();
            } else if (this.hiddenNeighborsPart != null) {
                this.updateHiddenNeighborPart();
            }
        } else if ("anchoreds".equals(event.getPropertyName())) {
            if (this.hiddenNeighborsPart == null) {
                Set<org.eclipse.gef4.graph.Node> hiddenNeighbors = this.getHidingModel().getHiddenNeighbors(this.getHost().getContent());
                if (!hiddenNeighbors.isEmpty()) {
                    this.createHiddenNeighborPart();
                }
            } else {
                this.updateHiddenNeighborPart();
            }
        }
    }

    protected void removeHiddenNeighborPart() {
        BehaviorUtils.removeAnchorages((IRootPart)this.getHost().getRoot(), Collections.singletonList(this.getHost()), Collections.singletonList(this.hiddenNeighborsPart));
        this.hiddenNeighborsPart = null;
    }

    protected void show() {
        ((Group)this.getHost().getVisual()).setVisible(true);
        ((Group)this.getHost().getVisual()).setMouseTransparent(false);
    }

    protected void updateHiddenNeighborPart() {
        this.hiddenNeighborsPart.refreshVisual();
    }
}

