/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.layout;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import org.eclipse.gef4.common.properties.IPropertyStore;
import org.eclipse.gef4.common.properties.PropertyStoreSupport;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.layout.IConnectionLayout;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.zest.fx.layout.GraphLayoutContext;

public class GraphEdgeLayout
implements IConnectionLayout {
    private GraphLayoutContext context;
    private Edge edge;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private PropertyStoreSupport pss = new PropertyStoreSupport((IPropertyStore)this, this.pcs);

    public GraphEdgeLayout(GraphLayoutContext context, Edge edge) {
        this.context = context;
        this.edge = edge;
        Object type = context.getGraph().getAttrs().get("type");
        if (type == "directed") {
            this.setProperty("directed", true);
        }
        for (Map.Entry e : edge.getAttrs().entrySet()) {
            this.setProperty((String)e.getKey(), e.getValue());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Object getProperty(String name) {
        return this.pss.getProperty(name);
    }

    public INodeLayout getSource() {
        return this.context.getNodeLayout(this.edge.getSource());
    }

    public INodeLayout getTarget() {
        return this.context.getNodeLayout(this.edge.getTarget());
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setProperty(String name, Object value) {
        this.pss.setProperty(name, value);
    }
}

