/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.models;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.Stack;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.models.ViewportModel;

public class ViewportStackModel {
    private Stack<ViewportState> viewportStack = new Stack();
    private Set<Graph> skipNextLayout = Collections.newSetFromMap(new IdentityHashMap());

    public void addSkipNextLayout(Graph graph) {
        this.skipNextLayout.add(graph);
    }

    public void pop(ViewportModel viewportModel) {
        if (!this.viewportStack.isEmpty()) {
            ViewportState state = this.viewportStack.pop();
            viewportModel.setTranslateX(state.tx);
            viewportModel.setTranslateY(state.ty);
            viewportModel.setContentsTransform(state.transform);
        }
    }

    public void push(ViewportModel viewportModel) {
        ViewportState state = new ViewportState();
        state.tx = viewportModel.getTranslateX();
        state.ty = viewportModel.getTranslateY();
        state.transform = viewportModel.getContentsTransform();
        this.viewportStack.push(state);
    }

    public boolean removeSkipNextLayout(Graph graph) {
        return this.skipNextLayout.remove(graph);
    }

    private static class ViewportState {
        public double tx;
        public double ty;
        public AffineTransform transform;

        private ViewportState() {
        }
    }
}

