/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.common.collect.SetMultimap;
import com.google.inject.Provider;
import java.util.Set;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.gef4.zest.fx.models.HidingModel;
import org.eclipse.gef4.zest.fx.parts.NodeContentPart;
import org.eclipse.gef4.zest.fx.parts.ZestFxHidingHandlePart;
import org.eclipse.gef4.zest.fx.policies.HideNodePolicy;

public class ZestFxExpandingHandlePart
extends ZestFxHidingHandlePart {
    public static final String IMG_EXPAND = "/expandall.gif";
    public static final String IMG_EXPAND_DISABLED = "/expandall_disabled.gif";

    public ZestFxExpandingHandlePart(Provider<BezierCurve[]> segmentsInSceneProvider, int segmentIndex, double segmentParameter) {
        super(segmentsInSceneProvider, segmentIndex, segmentParameter);
    }

    @Override
    protected Image getHoverImage() {
        return new Image(IMG_EXPAND);
    }

    @Override
    protected Image getImage() {
        return new Image(IMG_EXPAND_DISABLED);
    }

    @Override
    protected void onClicked(MouseEvent event) {
        SetMultimap anchorages = this.getAnchorages();
        if (anchorages == null || anchorages.isEmpty()) {
            return;
        }
        IVisualPart anchorage = (IVisualPart)anchorages.keySet().iterator().next();
        IViewer viewer = anchorage.getRoot().getViewer();
        HidingModel hidingModel = (HidingModel)viewer.getAdapter(HidingModel.class);
        Set<Node> hiddenNeighbors = hidingModel.getHiddenNeighbors(((NodeContentPart)anchorage).getContent());
        if (!hiddenNeighbors.isEmpty()) {
            for (Node node : hiddenNeighbors) {
                ((HideNodePolicy)((Object)((IContentPart)viewer.getContentPartMap().get(node)).getAdapter(HideNodePolicy.class))).show();
            }
        }
    }
}

